/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.okhttp3;

import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.HttpPathOverrideRequest;
import io.embrace.android.embracesdk.network.NetworkCaptureData;
import io.embrace.android.embracesdk.network.http.EmbraceHttpPathOverride;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.okhttp3.EmbraceOkHttp3PathOverrideRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

public final class EmbraceOkHttp3NetworkInterceptor
implements Interceptor {
    private static final String ENCODING_GZIP = "gzip";
    private Embrace embrace = Embrace.getInstance();
    private final String CONTENT_TYPE_EVENT_STREAM = "text/event-stream";

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String contentType;
        boolean serverSentEvent;
        if (this.embrace == null) {
            this.embrace = Embrace.getInstance();
        }
        Request userRequest = chain.request();
        Request.Builder requestBuilder = userRequest.newBuilder();
        boolean transparentGzip = false;
        if (userRequest.header("Accept-Encoding") == null && userRequest.header("Range") == null) {
            transparentGzip = true;
            requestBuilder.header("Accept-Encoding", ENCODING_GZIP);
        }
        Request request = requestBuilder.build();
        Response networkResponse = chain.proceed(request);
        Response.Builder responseBuilder = networkResponse.newBuilder().request(request);
        Long contentLength = null;
        String contentLengthHeader = networkResponse.header("Content-Length");
        if (contentLengthHeader != null) {
            try {
                contentLength = Long.parseLong(contentLengthHeader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = serverSentEvent = (contentType = networkResponse.header("Content-Type")) != null && contentType.startsWith("text/event-stream");
        if (!serverSentEvent && contentLength == null) {
            try {
                ResponseBody responseBody = networkResponse.body();
                if (responseBody != null) {
                    BufferedSource source = responseBody.source();
                    source.request(Long.MAX_VALUE);
                    contentLength = source.buffer().size();
                } else {
                    contentLength = 0L;
                }
            }
            catch (Exception responseBody) {
                // empty catch block
            }
        }
        if (contentLength == null) {
            contentLength = 0L;
        }
        if (transparentGzip && ENCODING_GZIP.equalsIgnoreCase(networkResponse.header("Content-Encoding")) && HttpHeaders.hasBody((Response)networkResponse)) {
            Headers strippedHeaders = networkResponse.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            responseBuilder.headers(strippedHeaders);
            ResponseBody responseBody = networkResponse.body();
            if (responseBody != null) {
                BufferedSource bufferedSource = Okio.buffer((Source)new GzipSource((Source)responseBody.source()));
                RealResponseBody realResponseBody = new RealResponseBody(contentType, contentLength.longValue(), bufferedSource);
                responseBuilder.body((ResponseBody)realResponseBody);
            }
        }
        Response response = responseBuilder.build();
        NetworkCaptureData networkCaptureData = null;
        if (this.embrace.isStarted()) {
            String traceIdHeader = this.embrace.getTraceIdHeader();
            if (this.embrace.shouldCaptureNetworkBody(request.url().toString(), request.method())) {
                networkCaptureData = new NetworkCaptureData();
                try {
                    networkCaptureData.withRequestHeaders(this.getProcessedHeaders(request.headers().toMultimap())).withRequestBody(EmbraceOkHttp3NetworkInterceptor.getRequestBody(request)).withRequestQueryParams(request.url().query()).withResponseHeaders(this.getProcessedHeaders(response.headers().toMultimap()));
                }
                catch (Exception e) {
                    EmbraceLogger.logDebug((String)"Failed to copy okhttp request data.", (Throwable)e);
                }
                ResponseBody okResponseBody = null;
                BufferedSource okResponseBodySource = null;
                try {
                    if (response.body() != null && (okResponseBody = response.body()).contentLength() >= 0L) {
                        okResponseBodySource = okResponseBody.source();
                        okResponseBodySource.request(102400L);
                        Buffer buffer = okResponseBodySource.buffer();
                        String responseBodyString = buffer.clone().readString(Charset.forName("UTF-8"));
                        byte[] responseBody = responseBodyString.getBytes();
                        if (responseBody.length > 102400) {
                            responseBody = Arrays.copyOf(responseBody, 102400);
                        }
                        networkCaptureData.withResponseBody(responseBody);
                    }
                }
                catch (Exception e) {
                    EmbraceLogger.logDebug((String)"Failed to copy okhttp response data.", (Throwable)e);
                }
            }
            this.embrace.logNetworkCall(EmbraceHttpPathOverride.getURLString((HttpPathOverrideRequest)new EmbraceOkHttp3PathOverrideRequest(request)), HttpMethod.fromString((String)request.method()), response.code(), response.sentRequestAtMillis(), response.receivedResponseAtMillis(), request.body() != null ? request.body().contentLength() : 0L, contentLength.longValue(), request.header(traceIdHeader), networkCaptureData);
        }
        return response;
    }

    private HashMap<String, String> getProcessedHeaders(Map<String, List<String>> properties) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> h : properties.entrySet()) {
            StringBuilder builder = new StringBuilder();
            for (String value : h.getValue()) {
                if (value == null) continue;
                builder.append(value);
            }
            headers.put(h.getKey(), builder.toString());
        }
        return headers;
    }

    private static byte[] getRequestBody(Request request) {
        try {
            Request copy = request.newBuilder().build();
            if (copy.body() == null) {
                return null;
            }
            Buffer buffer = new Buffer();
            copy.body().writeTo((BufferedSink)buffer);
            return buffer.readByteArray();
        }
        catch (IOException e) {
            EmbraceLogger.logDebug((String)"Failed to capture okhttp request body.", (Throwable)e);
            return null;
        }
    }
}

