/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.okhttp3;

import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealResponseBody;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

public final class EmbraceOkHttp3NetworkInterceptor
implements Interceptor {
    static final String ENCODING_GZIP = "gzip";
    private final String CONTENT_TYPE_EVENT_STREAM = "text/event-stream";
    final Embrace embrace = Embrace.getInstance();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String contentType;
        boolean serverSentEvent;
        Request userRequest = chain.request();
        Request.Builder requestBuilder = userRequest.newBuilder();
        boolean transparentGzip = false;
        if (userRequest.header("Accept-Encoding") == null && userRequest.header("Range") == null) {
            transparentGzip = true;
            requestBuilder.header("Accept-Encoding", ENCODING_GZIP);
        }
        Request request = requestBuilder.build();
        Response networkResponse = chain.proceed(request);
        Response.Builder responseBuilder = networkResponse.newBuilder().request(request);
        Long contentLength = null;
        if (networkResponse.header("Content-Length") != null) {
            try {
                contentLength = Long.parseLong(networkResponse.header("Content-Length"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = serverSentEvent = (contentType = networkResponse.header("Content-Type")) != null && contentType.startsWith("text/event-stream");
        if (!serverSentEvent && contentLength == null) {
            try {
                BufferedSource source = networkResponse.body().source();
                source.request(Long.MAX_VALUE);
                contentLength = source.buffer().size();
            }
            catch (Exception source) {
                // empty catch block
            }
        }
        if (contentLength == null) {
            contentLength = 0L;
        }
        if (transparentGzip && ENCODING_GZIP.equalsIgnoreCase(networkResponse.header("Content-Encoding")) && HttpHeaders.hasBody((Response)networkResponse)) {
            Headers strippedHeaders = networkResponse.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            responseBuilder.headers(strippedHeaders);
            responseBuilder.body((ResponseBody)new RealResponseBody(strippedHeaders, Okio.buffer((Source)new GzipSource((Source)networkResponse.body().source()))));
        }
        Response response = responseBuilder.build();
        if (this.embrace.isStarted()) {
            this.embrace.logNetworkCall(request.url().toString(), HttpMethod.fromString((String)request.method()), response.code(), response.sentRequestAtMillis(), response.receivedResponseAtMillis(), request.body() != null ? request.body().contentLength() : 0L, contentLength.longValue());
        }
        return response;
    }
}

