/*
  $Id: Rule.java 2704 2013-04-24 21:30:32Z dfisher $

  Copyright (C) 2003-2013 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 2704 $
  Updated: $Date: 2013-04-24 17:30:32 -0400 (Wed, 24 Apr 2013) $
*/
package edu.vt.middleware.password;

/**
 * Interface for password strength rules.
 *
 * @author  Middleware Services
 * @version  $Revision: 2704 $ $Date: 2013-04-24 17:30:32 -0400 (Wed, 24 Apr 2013) $
 */
public interface Rule
{


  /**
   * Validates the supplied password data per the requirements of this rule.
   *
   * @param  passwordData  to verify (not null).
   *
   * @return  details on password verification
   *
   * @throws  NullPointerException  if the rule data is null.
   */
  RuleResult validate(PasswordData passwordData);
}
