/*
  $Id: AlphabeticalSequenceRule.java 2704 2013-04-24 21:30:32Z dfisher $

  Copyright (C) 2003-2013 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 2704 $
  Updated: $Date: 2013-04-24 17:30:32 -0400 (Wed, 24 Apr 2013) $
*/
package edu.vt.middleware.password;

/**
 * Rule for determining if a password contains an alphabetical keyboard
 * sequence. Both uppercase and lowercase sequences are checked. The default
 * sequence length is 5 characters.
 *
 * <ul>
 *   <li>Sequences are of the form: 'stuvw' or 'KLMNO'</li>
 *   <li>If wrap=true: 'yzabc' will match</li>
 * </ul>
 *
 * @author  Middleware Services
 * @version  $Revision: 2704 $ $Date: 2013-04-24 17:30:32 -0400 (Wed, 24 Apr 2013) $
 */
public class AlphabeticalSequenceRule extends AbstractSequenceRule
{

  /** Letters of the alphabet. */
  private static final char[][] LETTERS = new char[][] {
    new char[] {'a', 'A'},
    new char[] {'b', 'B'},
    new char[] {'c', 'C'},
    new char[] {'d', 'D'},
    new char[] {'e', 'E'},
    new char[] {'f', 'F'},
    new char[] {'g', 'G'},
    new char[] {'h', 'H'},
    new char[] {'i', 'I'},
    new char[] {'j', 'J'},
    new char[] {'k', 'K'},
    new char[] {'l', 'L'},
    new char[] {'m', 'M'},
    new char[] {'n', 'N'},
    new char[] {'o', 'O'},
    new char[] {'p', 'P'},
    new char[] {'q', 'Q'},
    new char[] {'r', 'R'},
    new char[] {'s', 'S'},
    new char[] {'t', 'T'},
    new char[] {'u', 'U'},
    new char[] {'v', 'V'},
    new char[] {'w', 'W'},
    new char[] {'x', 'X'},
    new char[] {'y', 'Y'},
    new char[] {'z', 'Z'},
  };

  /** Array of all the characters in this sequence rule. */
  private static final char[][][] ALL_CHARS = new char[][][] {LETTERS, };


  /** Default constructor. */
  public AlphabeticalSequenceRule()
  {
    this(DEFAULT_SEQUENCE_LENGTH, false);
  }


  /**
   * Creates a new alphabetical sequence rule.
   *
   * @param  sl  sequence length
   * @param  wrap  whether to wrap search sequences
   */
  public AlphabeticalSequenceRule(final int sl, final boolean wrap)
  {
    setSequenceLength(sl);
    wrapSequence = wrap;
  }


  /** {@inheritDoc} */
  @Override
  protected char[][] getSequence(final int n)
  {
    return ALL_CHARS[n];
  }


  /** {@inheritDoc} */
  @Override
  protected int getSequenceCount()
  {
    return ALL_CHARS.length;
  }
}
