/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.handler;

import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.handler.DefaultConnectionHandler;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TlsConnectionHandler
extends DefaultConnectionHandler {
    private StartTlsResponse startTlsResponse;
    private boolean stopTlsOnClose;

    public TlsConnectionHandler() {
    }

    public TlsConnectionHandler(LdapConfig lc) {
        super(lc);
    }

    public TlsConnectionHandler(TlsConnectionHandler ch) {
        this.setLdapConfig(ch.getLdapConfig());
        this.setConnectionStrategy(ch.getConnectionStrategy());
        this.setConnectionRetryExceptions(ch.getConnectionRetryExceptions());
        this.setConnectionCount(ch.getConnectionCount());
        this.setStopTlsOnClose(ch.getStopTlsOnClose());
    }

    public boolean getStopTlsOnClose() {
        return this.stopTlsOnClose;
    }

    public void setStopTlsOnClose(boolean b) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting stopTlsOnClose: " + b));
        }
        this.stopTlsOnClose = b;
    }

    public StartTlsResponse getStartTlsResponse() {
        return this.startTlsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectInternal(String authtype, String dn, Object credential, Hashtable<String, Object> env) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Bind with the following parameters:");
            this.logger.debug((Object)("  authtype = " + authtype));
            this.logger.debug((Object)("  dn = " + dn));
            if (this.config.getLogCredentials()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("  credential = " + credential));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"  credential = <suppressed>");
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("  env = " + env));
            }
        }
        env.put("java.naming.ldap.version", "3");
        try {
            this.context = new InitialLdapContext(env, null);
            this.startTlsResponse = this.startTls(this.context);
            this.context.addToEnvironment("java.naming.security.authentication", authtype);
            if (dn != null) {
                this.context.addToEnvironment("java.naming.security.principal", dn);
                if (credential != null) {
                    if (this.context.getEnvironment().containsKey("java.naming.referral") && "follow".equals(this.context.getEnvironment().get("java.naming.referral"))) {
                        throw new ConfigurationException("Referral following with credentials is not supported with startTLS, use LDAPS instead.");
                    }
                    this.context.addToEnvironment("java.naming.security.credentials", credential);
                }
            }
            this.context.reconnect(null);
        }
        catch (NamingException e) {
            if (this.context != null) {
                try {
                    this.context.close();
                }
                finally {
                    this.context = null;
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws NamingException {
        try {
            if (this.stopTlsOnClose) {
                this.stopTls(this.startTlsResponse);
            }
        }
        catch (NamingException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)"Error stopping TLS", (Throwable)e);
            }
        }
        finally {
            this.startTlsResponse = null;
            super.close();
        }
    }

    public StartTlsResponse startTls(LdapContext ctx) throws NamingException {
        StartTlsResponse tls = null;
        try {
            tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
            if (this.config.useHostnameVerifier()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("TLS hostnameVerifier = " + this.config.getHostnameVerifier()));
                }
                tls.setHostnameVerifier(this.config.getHostnameVerifier());
            }
            if (this.config.useSslSocketFactory()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("TLS sslSocketFactory = " + this.config.getSslSocketFactory()));
                }
                tls.negotiate(this.config.getSslSocketFactory());
            } else {
                tls.negotiate();
            }
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)"Could not negotiate TLS connection", (Throwable)e);
            }
            throw new CommunicationException(e.getMessage());
        }
        return tls;
    }

    public void stopTls(StartTlsResponse tls) throws NamingException {
        if (tls != null) {
            try {
                tls.close();
            }
            catch (IOException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)"Could not close TLS connection", (Throwable)e);
                }
                throw new CommunicationException(e.getMessage());
            }
        }
    }

    @Override
    public TlsConnectionHandler newInstance() {
        return new TlsConnectionHandler(this);
    }
}

