/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.bean;

import edu.vt.middleware.ldap.LdapUtil;
import edu.vt.middleware.ldap.bean.AbstractLdapBean;
import edu.vt.middleware.ldap.bean.LdapAttribute;
import edu.vt.middleware.ldap.bean.LdapBeanFactory;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLdapAttribute<T extends Set<Object>>
extends AbstractLdapBean
implements LdapAttribute {
    protected static final int HASH_CODE_SEED = 41;
    protected String name;
    protected Set<Object> values;

    public AbstractLdapAttribute(LdapBeanFactory lbf) {
        super(lbf);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<Object> getValues() {
        return this.values;
    }

    @Override
    public abstract Set<String> getStringValues();

    @Override
    public void setAttribute(Attribute attribute) throws NamingException {
        this.setName(attribute.getID());
        NamingEnumeration<?> ne = attribute.getAll();
        while (ne.hasMore()) {
            this.values.add(ne.next());
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int hashCode() {
        int hc = 41;
        if (this.name != null) {
            hc += this.name.hashCode();
        }
        for (String s : this.getStringValues()) {
            if (s == null) continue;
            hc += s.hashCode();
        }
        return hc;
    }

    public String toString() {
        return String.format("%s%s", this.name, this.values);
    }

    @Override
    public Attribute toAttribute() {
        BasicAttribute attribute = new BasicAttribute(this.name);
        for (Object o : this.values) {
            attribute.add(o);
        }
        return attribute;
    }

    protected void convertValuesToString(Set<String> stringValues) {
        for (Object o : this.values) {
            if (o == null) continue;
            if (o instanceof String) {
                stringValues.add((String)o);
                continue;
            }
            if (o instanceof byte[]) {
                String encodedValue = LdapUtil.base64Encode((byte[])o);
                if (encodedValue == null) continue;
                stringValues.add(encodedValue);
                continue;
            }
            stringValues.add(o.toString());
        }
    }
}

