/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.auth;

import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.auth.ConstructDnResolver;
import edu.vt.middleware.ldap.auth.DnResolver;
import edu.vt.middleware.ldap.auth.SearchDnResolver;
import edu.vt.middleware.ldap.auth.handler.AuthenticationHandler;
import edu.vt.middleware.ldap.auth.handler.AuthenticationResultHandler;
import edu.vt.middleware.ldap.auth.handler.AuthorizationHandler;
import edu.vt.middleware.ldap.auth.handler.BindAuthenticationHandler;
import edu.vt.middleware.ldap.props.LdapConfigPropertyInvoker;
import edu.vt.middleware.ldap.props.LdapProperties;
import java.io.InputStream;
import java.util.Arrays;

public class AuthenticatorConfig
extends LdapConfig {
    public static final String PROPERTIES_DOMAIN = "edu.vt.middleware.ldap.auth.";
    private static final LdapConfigPropertyInvoker PROPERTIES = new LdapConfigPropertyInvoker(AuthenticatorConfig.class, "edu.vt.middleware.ldap.auth.");
    private String[] userField = new String[]{"uid"};
    private String userFilter;
    private Object[] userFilterArgs;
    private String user;
    private Object credential;
    private String authorizationFilter;
    private Object[] authorizationFilterArgs;
    private boolean allowMultipleDns = false;
    private DnResolver dnResolver = new SearchDnResolver(this);
    private AuthenticationHandler authenticationHandler = new BindAuthenticationHandler(this);
    private AuthenticationResultHandler[] authenticationResultHandlers;
    private AuthorizationHandler[] authorizationHandlers;

    public AuthenticatorConfig() {
        this.setSearchScope(LdapConfig.SearchScope.ONELEVEL);
    }

    public AuthenticatorConfig(String ldapUrl, String baseDn) {
        this();
        this.setLdapUrl(ldapUrl);
        this.setBaseDn(baseDn);
    }

    public String[] getUserField() {
        return this.userField;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public Object[] getUserFilterArgs() {
        return this.userFilterArgs;
    }

    public String getUser() {
        return this.user;
    }

    public Object getCredential() {
        return this.credential;
    }

    public String getAuthorizationFilter() {
        return this.authorizationFilter;
    }

    public Object[] getAuthorizationFilterArgs() {
        return this.authorizationFilterArgs;
    }

    public boolean getConstructDn() {
        return this.dnResolver != null && this.dnResolver.getClass().isAssignableFrom(ConstructDnResolver.class);
    }

    public boolean getAllowMultipleDns() {
        return this.allowMultipleDns;
    }

    public boolean getSubtreeSearch() {
        return LdapConfig.SearchScope.SUBTREE == this.getSearchScope();
    }

    public DnResolver getDnResolver() {
        return this.dnResolver;
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public AuthenticationResultHandler[] getAuthenticationResultHandlers() {
        return this.authenticationResultHandlers;
    }

    public AuthorizationHandler[] getAuthorizationHandlers() {
        return this.authorizationHandlers;
    }

    public void setUserField(String[] userField) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting userField: " + Arrays.toString(userField)));
        }
        this.userField = userField;
    }

    public void setUserFilter(String userFilter) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting userFilter: " + userFilter));
        }
        this.userFilter = userFilter;
    }

    public void setUserFilterArgs(Object[] userFilterArgs) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting userFilterArgs: " + Arrays.toString(userFilterArgs)));
        }
        this.userFilterArgs = userFilterArgs;
    }

    public void setUser(String user) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting user: " + user));
        }
        this.user = user;
    }

    public void setCredential(Object credential) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            if (this.getLogCredentials()) {
                this.logger.trace((Object)("setting credential: " + credential));
            } else {
                this.logger.trace((Object)"setting credential: <suppressed>");
            }
        }
        this.credential = credential;
    }

    public void setAuthorizationFilter(String authorizationFilter) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting authorizationFilter: " + authorizationFilter));
        }
        this.authorizationFilter = authorizationFilter;
    }

    public void setAuthorizationFilterArgs(Object[] authorizationFilterArgs) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting authorizationFilterArgs: " + Arrays.toString(authorizationFilterArgs)));
        }
        this.authorizationFilterArgs = authorizationFilterArgs;
    }

    public void setConstructDn(boolean constructDn) {
        if (constructDn) {
            this.setDnResolver(new ConstructDnResolver());
        } else {
            this.setDnResolver(new SearchDnResolver());
        }
    }

    public void setAllowMultipleDns(boolean allowMultipleDns) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting allowMultipleDns: " + allowMultipleDns));
        }
        this.allowMultipleDns = allowMultipleDns;
    }

    public void setSubtreeSearch(boolean subtreeSearch) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting subtreeSearch: " + subtreeSearch));
        }
        if (subtreeSearch) {
            this.setSearchScope(LdapConfig.SearchScope.SUBTREE);
        } else {
            this.setSearchScope(LdapConfig.SearchScope.ONELEVEL);
        }
    }

    public void setDnResolver(DnResolver resolver) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting dnResolver: " + resolver));
        }
        this.dnResolver = resolver;
        if (this.dnResolver != null) {
            this.dnResolver.setAuthenticatorConfig(this);
        }
    }

    public void setAuthenticationHandler(AuthenticationHandler handler) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting authenticationHandler: " + handler));
        }
        this.authenticationHandler = handler;
        if (this.authenticationHandler != null) {
            this.authenticationHandler.setAuthenticatorConfig(this);
        }
    }

    public void setAuthenticationResultHandlers(AuthenticationResultHandler[] handlers) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting authenticationResultHandlers: " + handlers));
        }
        this.authenticationResultHandlers = handlers;
    }

    public void setAuthorizationHandlers(AuthorizationHandler[] handlers) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting authorizationHandlers: " + handlers));
        }
        this.authorizationHandlers = handlers;
    }

    public String getPropertiesDomain() {
        return PROPERTIES_DOMAIN;
    }

    public void setEnvironmentProperties(String name, String value) {
        this.checkImmutable();
        if (name != null && value != null) {
            if (PROPERTIES.hasProperty(name)) {
                PROPERTIES.setProperty(this, name, value);
            } else {
                super.setEnvironmentProperties(name, value);
            }
        }
    }

    public boolean hasEnvironmentProperty(String name) {
        return PROPERTIES.hasProperty(name);
    }

    public static AuthenticatorConfig createFromProperties(InputStream is) {
        AuthenticatorConfig authConfig = new AuthenticatorConfig();
        LdapProperties properties = null;
        if (is != null) {
            properties = new LdapProperties(authConfig, is);
        } else {
            properties = new LdapProperties(authConfig);
            properties.useDefaultPropertiesFile();
        }
        properties.configure();
        return authConfig;
    }
}

