/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggregateTrustManager
implements X509TrustManager {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private X509TrustManager[] trustManagers;

    public AggregateTrustManager(X509TrustManager ... managers) {
        this.trustManagers = managers;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustManagers != null) {
            for (X509TrustManager tm : this.trustManagers) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("invoking checkClientTrusted for " + tm));
                }
                tm.checkClientTrusted(chain, authType);
            }
        }
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustManagers != null) {
            for (X509TrustManager tm : this.trustManagers) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("invoking checkServerTrusted for " + tm));
                }
                tm.checkServerTrusted(chain, authType);
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> issuers = new ArrayList<X509Certificate>();
        if (this.trustManagers != null) {
            for (X509TrustManager tm : this.trustManagers) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("invoking getAcceptedIssuers invoked for " + tm));
                }
                for (X509Certificate cert : tm.getAcceptedIssuers()) {
                    issuers.add(cert);
                }
            }
        }
        return issuers.toArray(new X509Certificate[issuers.size()]);
    }
}

