/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.props;

import edu.vt.middleware.ldap.auth.DnResolver;
import edu.vt.middleware.ldap.auth.handler.AuthenticationHandler;
import edu.vt.middleware.ldap.auth.handler.AuthenticationResultHandler;
import edu.vt.middleware.ldap.auth.handler.AuthorizationHandler;
import edu.vt.middleware.ldap.handler.ConnectionHandler;
import edu.vt.middleware.ldap.handler.SearchResultHandler;
import edu.vt.middleware.ldap.props.AbstractPropertyInvoker;
import edu.vt.middleware.ldap.props.ConfigParser;
import edu.vt.middleware.ldap.ssl.CredentialConfigParser;
import edu.vt.middleware.ldap.ssl.SSLContextInitializer;
import java.lang.reflect.Array;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapConfigPropertyInvoker
extends AbstractPropertyInvoker {
    public LdapConfigPropertyInvoker(Class<?> c, String propertiesDomain) {
        this.initialize(c, propertiesDomain);
    }

    @Override
    protected Object convertValue(Class<?> type, String value) {
        Object newValue = value;
        if (type != String.class) {
            if (SSLSocketFactory.class.isAssignableFrom(type)) {
                if ("null".equals(value)) {
                    newValue = null;
                } else if (CredentialConfigParser.isCredentialConfig(value)) {
                    CredentialConfigParser configParser = new CredentialConfigParser(value);
                    newValue = LdapConfigPropertyInvoker.instantiateType(SSLSocketFactory.class, configParser.getSslSocketFactoryClassName());
                    Object credentialConfig = configParser.initializeType();
                    try {
                        LdapConfigPropertyInvoker.invokeMethod(newValue.getClass().getMethod("setSSLContextInitializer", SSLContextInitializer.class), newValue, LdapConfigPropertyInvoker.invokeMethod(credentialConfig.getClass().getMethod("createSSLContextInitializer", new Class[0]), credentialConfig, null));
                        LdapConfigPropertyInvoker.invokeMethod(newValue.getClass().getMethod("initialize", new Class[0]), newValue, null);
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else if (ConfigParser.isConfig(value)) {
                    ConfigParser configParser = new ConfigParser(value);
                    newValue = configParser.initializeType();
                } else {
                    newValue = LdapConfigPropertyInvoker.instantiateType(SSLSocketFactory.class, value);
                }
            } else if (HostnameVerifier.class.isAssignableFrom(type)) {
                newValue = this.createTypeFromPropertyValue(HostnameVerifier.class, value);
            } else if (ConnectionHandler.class.isAssignableFrom(type)) {
                newValue = this.createTypeFromPropertyValue(ConnectionHandler.class, value);
            } else if (AuthenticationHandler.class.isAssignableFrom(type)) {
                newValue = this.createTypeFromPropertyValue(AuthenticationHandler.class, value);
            } else if (DnResolver.class.isAssignableFrom(type)) {
                newValue = this.createTypeFromPropertyValue(DnResolver.class, value);
            } else if (SearchResultHandler[].class.isAssignableFrom(type)) {
                newValue = this.createArrayTypeFromPropertyValue(SearchResultHandler.class, value);
            } else if (AuthenticationResultHandler[].class.isAssignableFrom(type)) {
                newValue = this.createArrayTypeFromPropertyValue(AuthenticationResultHandler.class, value);
            } else if (AuthorizationHandler[].class.isAssignableFrom(type)) {
                newValue = this.createArrayTypeFromPropertyValue(AuthorizationHandler.class, value);
            } else if (Class.class.isAssignableFrom(type)) {
                newValue = this.createTypeFromPropertyValue(Class.class, value);
            } else if (Class[].class.isAssignableFrom(type)) {
                newValue = this.createArrayTypeFromPropertyValue(Class.class, value);
            } else if (type.isEnum()) {
                for (Object o : type.getEnumConstants()) {
                    Enum e = (Enum)o;
                    if (!e.name().equals(value)) continue;
                    newValue = o;
                }
            } else if (String[].class == type) {
                newValue = value.split(",");
            } else if (Object[].class == type) {
                newValue = value.split(",");
            } else if (Float.TYPE == type) {
                newValue = Float.valueOf(Float.parseFloat(value));
            } else if (Integer.TYPE == type) {
                newValue = Integer.parseInt(value);
            } else if (Long.TYPE == type) {
                newValue = Long.parseLong(value);
            } else if (Short.TYPE == type) {
                newValue = Short.parseShort(value);
            } else if (Double.TYPE == type) {
                newValue = Double.parseDouble(value);
            } else if (Boolean.TYPE == type) {
                newValue = Boolean.valueOf(value);
            }
        }
        return newValue;
    }

    protected Object createTypeFromPropertyValue(Class<?> c, String s) {
        Class<?> newObject = null;
        if ("null".equals(s)) {
            newObject = null;
        } else if (ConfigParser.isConfig(s)) {
            ConfigParser configParser = new ConfigParser(s);
            newObject = configParser.initializeType();
        } else {
            newObject = Class.class == c ? LdapConfigPropertyInvoker.createClass(s) : LdapConfigPropertyInvoker.instantiateType(c, s);
        }
        return newObject;
    }

    protected Object createArrayTypeFromPropertyValue(Class<?> c, String s) {
        Object newObject = null;
        if ("null".equals(s)) {
            newObject = null;
        } else if (s.indexOf("},") != -1) {
            String[] classes = s.split("\\},");
            newObject = Array.newInstance(c, classes.length);
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = classes[i] + "}";
                if (!ConfigParser.isConfig(classes[i])) {
                    throw new IllegalArgumentException("Could not parse property string: " + classes[i]);
                }
                ConfigParser configParser = new ConfigParser(classes[i]);
                Array.set(newObject, i, configParser.initializeType());
            }
        } else {
            String[] classes = s.split(",");
            newObject = Array.newInstance(c, classes.length);
            for (int i = 0; i < classes.length; ++i) {
                if (ConfigParser.isConfig(classes[i])) {
                    ConfigParser configParser = new ConfigParser(classes[i]);
                    Array.set(newObject, i, configParser.initializeType());
                    continue;
                }
                if (Class.class == c) {
                    Array.set(newObject, i, LdapConfigPropertyInvoker.createClass(classes[i]));
                    continue;
                }
                Array.set(newObject, i, LdapConfigPropertyInvoker.instantiateType(c, classes[i]));
            }
        }
        return newObject;
    }
}

