/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.jaas;

import com.sun.security.auth.callback.TextCallbackHandler;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.jaas.AbstractLoginModule;
import edu.vt.middleware.ldap.jaas.LdapDnPrincipal;
import edu.vt.middleware.ldap.jaas.LdapPrincipal;
import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapRoleAuthorizationModule
extends AbstractLoginModule
implements LoginModule {
    private String roleFilter;
    private String[] roleAttribute = new String[0];
    private boolean noResultsIsError;
    private Ldap ldap;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (key.equalsIgnoreCase("roleFilter")) {
                this.roleFilter = value;
                continue;
            }
            if (key.equalsIgnoreCase("roleAttribute")) {
                if ("*".equals(value)) {
                    this.roleAttribute = null;
                    continue;
                }
                this.roleAttribute = value.split(",");
                continue;
            }
            if (!key.equalsIgnoreCase("noResultsIsError")) continue;
            this.noResultsIsError = Boolean.valueOf(value);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("roleFilter = " + this.roleFilter));
            this.logger.debug((Object)("roleAttribute = " + Arrays.toString(this.roleAttribute)));
            this.logger.debug((Object)("noResultsIsError = " + this.noResultsIsError));
        }
        this.ldap = LdapRoleAuthorizationModule.createLdap(options);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created ldap: " + this.ldap.getLdapConfig()));
        }
    }

    @Override
    public boolean login() throws LoginException {
        try {
            String loginDn;
            String loginName;
            NameCallback nameCb = new NameCallback("Enter user: ");
            PasswordCallback passCb = new PasswordCallback("Enter user password: ", false);
            this.getCredentials(nameCb, passCb, false);
            if (nameCb.getName() == null && this.tryFirstPass) {
                this.getCredentials(nameCb, passCb, true);
            }
            if ((loginName = nameCb.getName()) != null && this.setLdapPrincipal) {
                this.principals.add(new LdapPrincipal(loginName));
                this.loginSuccess = true;
            }
            if ((loginDn = (String)this.sharedState.get("edu.vt.middleware.ldap.jaas.login.entryDn")) != null && this.setLdapDnPrincipal) {
                this.principals.add(new LdapDnPrincipal(loginDn));
                this.loginSuccess = true;
            }
            if (this.roleFilter != null) {
                Object[] filterArgs = new Object[]{loginDn, loginName};
                Iterator<SearchResult> results = this.ldap.search(new SearchFilter(this.roleFilter, filterArgs), this.roleAttribute);
                if (!results.hasNext() && this.noResultsIsError) {
                    this.loginSuccess = false;
                    throw new LoginException("Could not find roles using " + this.roleFilter);
                }
                while (results.hasNext()) {
                    SearchResult sr = results.next();
                    this.roles.addAll(this.attributesToRoles(sr.getAttributes()));
                }
            }
            if (this.defaultRole != null && !this.defaultRole.isEmpty()) {
                this.roles.addAll(this.defaultRole);
            }
            if (!this.roles.isEmpty()) {
                this.loginSuccess = true;
            }
            this.storeCredentials(nameCb, passCb, null);
        }
        catch (NamingException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Error occured attempting role lookup", (Throwable)e);
            }
            this.loginSuccess = false;
            throw new LoginException(e.getMessage());
        }
        finally {
            this.ldap.close();
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String name = "vt-ldap-role";
        if (args.length > 0) {
            name = args[0];
        }
        LoginContext lc = new LoginContext(name, new TextCallbackHandler());
        lc.login();
        System.out.println("Authorization succeeded");
        Set<Principal> principals = lc.getSubject().getPrincipals();
        System.out.println("Subject Principal(s): ");
        for (Principal p : principals) {
            System.out.println("  " + p.getName());
        }
        lc.logout();
    }
}

