/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ssl;

import edu.vt.middleware.ldap.ssl.SSLContextInitializer;
import edu.vt.middleware.ldap.ssl.TLSSocketFactory;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingletonTLSSocketFactory
extends TLSSocketFactory {
    protected static SSLContextInitializer staticContextInitializer;

    public void setSSLContextInitializer(SSLContextInitializer initializer) {
        Log logger;
        if (staticContextInitializer != null && (logger = LogFactory.getLog(SingletonTLSSocketFactory.class)).isWarnEnabled()) {
            logger.warn((Object)"SSLContextInitializer is being overridden");
        }
        staticContextInitializer = initializer;
    }

    public void initialize() throws GeneralSecurityException {
        super.setSSLContextInitializer(staticContextInitializer);
        super.initialize();
    }

    public static SocketFactory getDefault() {
        SingletonTLSSocketFactory sf;
        block2: {
            sf = new SingletonTLSSocketFactory();
            try {
                sf.initialize();
            }
            catch (GeneralSecurityException e) {
                Log logger = LogFactory.getLog(SingletonTLSSocketFactory.class);
                if (!logger.isErrorEnabled()) break block2;
                logger.error((Object)"Error initializing socket factory", (Throwable)e);
            }
        }
        return sf;
    }
}

