/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.util;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.util.Convert;
import edu.vt.middleware.crypt.util.PemHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

public final class CryptWriter {
    protected CryptWriter() {
    }

    public static void writeEncodedKey(Key key, File file) throws IOException {
        CryptWriter.writeEncodedKey(key, new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static void writeEncodedKey(Key key, OutputStream out) throws IOException {
        CryptWriter.writeData(out, key.getEncoded());
    }

    public static void writePemKey(PublicKey key, File file) throws IOException {
        CryptWriter.writePemKey(key, new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static void writePemKey(PublicKey key, OutputStream out) throws IOException {
        CryptWriter.writeData(out, Convert.toAsciiBytes(PemHelper.encodeKey(key)));
    }

    public static void writePemKey(PrivateKey key, char[] password, SecureRandom random, File file) throws IOException {
        CryptWriter.writePemKey(key, password, random, new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static void writePemKey(PrivateKey key, char[] password, SecureRandom random, OutputStream out) throws IOException {
        CryptWriter.writeData(out, Convert.toAsciiBytes(PemHelper.encodeKey(key, password, random)));
    }

    public static void writeEncodedCertificate(Certificate cert, File file) throws CryptException, IOException {
        CryptWriter.writeEncodedCertificate(cert, new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static void writeEncodedCertificate(Certificate cert, OutputStream out) throws CryptException, IOException {
        try {
            CryptWriter.writeData(out, cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new CryptException("Cannot generate encoded certificate.", e);
        }
    }

    public static void writePemCertificate(Certificate cert, File file) throws IOException {
        CryptWriter.writePemCertificate(cert, new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static void writePemCertificate(Certificate cert, OutputStream out) throws IOException {
        CryptWriter.writeData(out, Convert.toAsciiBytes(PemHelper.encodeCert(cert)));
    }

    public static void writeEncodedCertificates(Certificate[] certs, File file) throws CryptException, IOException {
        CryptWriter.writeEncodedCertificates(certs, new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static void writeEncodedCertificates(Certificate[] certs, OutputStream out) throws CryptException, IOException {
        try {
            for (int i = 0; i < certs.length; ++i) {
                out.write(certs[i].getEncoded());
            }
        }
        catch (CertificateEncodingException e) {
            throw new CryptException("Cannot generate encoded certificate.", e);
        }
        finally {
            out.close();
        }
    }

    public static void writePemCertificates(Certificate[] certs, File file) throws IOException {
        CryptWriter.writePemCertificates(certs, new BufferedOutputStream(new FileOutputStream(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePemCertificates(Certificate[] certs, OutputStream out) throws IOException {
        try {
            for (int i = 0; i < certs.length; ++i) {
                out.write(Convert.toAsciiBytes(PemHelper.encodeCert(certs[i])));
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeData(OutputStream out, byte[] data) throws IOException {
        try {
            out.write(data);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

