/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.pbe;

import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.pbe.AbstractEncryptionScheme;
import edu.vt.middleware.crypt.pbe.KeyGenerator;
import edu.vt.middleware.crypt.pbe.PBKDF1KeyGenerator;
import edu.vt.middleware.crypt.pkcs.PBEParameter;
import edu.vt.middleware.crypt.pkcs.PBES1Algorithm;
import edu.vt.middleware.crypt.symmetric.SymmetricAlgorithm;
import javax.crypto.spec.SecretKeySpec;

public class PBES1EncryptionScheme
extends AbstractEncryptionScheme {
    public static final int KEY_LENGTH = 8;
    public static final int IV_LENGTH = 8;
    private static final int DKEY_BIT_LENGTH = 128;
    private KeyGenerator generator;

    public PBES1EncryptionScheme(PBES1Algorithm alg, PBEParameter params) {
        this.setCipher(SymmetricAlgorithm.newInstance(alg.getSpec()));
        this.generator = new PBKDF1KeyGenerator(alg.getDigest(), params.getSalt(), params.getIterationCount());
    }

    public PBES1EncryptionScheme(SymmetricAlgorithm alg, DigestAlgorithm digest, PBEParameter params) {
        boolean valid = false;
        for (PBES1Algorithm a : PBES1Algorithm.values()) {
            if (!a.getDigest().getAlgorithm().equals(digest.getAlgorithm()) || !a.getSpec().getName().equals(alg.getAlgorithm()) || !a.getSpec().getMode().equals(alg.getMode()) || !a.getSpec().getPadding().equals(alg.getPadding())) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new IllegalArgumentException("Invalid digest/cipher combination.");
        }
        this.setCipher(alg);
        this.generator = new PBKDF1KeyGenerator(digest, params.getSalt(), params.getIterationCount());
    }

    protected void initCipher(char[] password) {
        byte[] derivedKey = this.generator.generate(password, 128);
        byte[] keyBytes = new byte[8];
        System.arraycopy(derivedKey, 0, keyBytes, 0, 8);
        this.cipher.setKey(new SecretKeySpec(keyBytes, this.cipher.getAlgorithm()));
        if (!this.cipher.hasIV()) {
            byte[] ivBytes = new byte[8];
            System.arraycopy(derivedKey, 8, ivBytes, 0, 8);
            this.cipher.setIV(ivBytes);
        }
    }
}

