/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.irds.agepredictor.cmdline.authorage;

import edu.usc.irds.agepredictor.cmdline.authorage.AgeClassifyEvaluationErrorListener;
import edu.usc.irds.agepredictor.cmdline.authorage.AgeClassifyFineGrainedReportListener;
import edu.usc.irds.agepredictor.cmdline.params.EvalToolParams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import opennlp.tools.authorage.AgeClassifyEvaluationMonitor;
import opennlp.tools.authorage.AgeClassifyEvaluator;
import opennlp.tools.authorage.AgeClassifyME;
import opennlp.tools.authorage.AgeClassifyModel;
import opennlp.tools.authorage.AuthorAgeSample;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.util.ObjectStream;

public final class AgeClassifyEvaluatorTool
extends AbstractEvaluatorTool<AuthorAgeSample, EvalToolParams> {
    public AgeClassifyEvaluatorTool() {
        super(AuthorAgeSample.class, EvalToolParams.class);
    }

    public String getShortDescription() {
        return "measures the performance of the AgeClassify model with the reference data";
    }

    public String getHelp(String format) {
        if ("".equals(format) || "opennlp".equals(format)) {
            return this.getBasicHelp(new Class[]{this.paramsClass, StreamFactoryRegistry.getFactory((Class)this.type, (String)"opennlp").getParameters()});
        }
        ObjectStreamFactory factory = StreamFactoryRegistry.getFactory((Class)this.type, (String)format);
        if (null == factory) {
            throw new TerminateToolException(1, "Format " + format + " is not found.\n" + this.getHelp());
        }
        return "Usage: bin/authorage " + this.getName() + " " + ArgumentParser.createUsage((Class[])new Class[]{this.paramsClass, factory.getParameters()});
    }

    public void run(String format, String[] args) {
        AgeClassifyModel model;
        super.run(format, args);
        try {
            model = new AgeClassifyModel(((EvalToolParams)this.params).getModel());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        LinkedList<AgeClassifyEvaluationMonitor> listeners = new LinkedList<AgeClassifyEvaluationMonitor>();
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new AgeClassifyEvaluationErrorListener());
        }
        AgeClassifyFineGrainedReportListener reportListener = null;
        File reportFile = ((EvalToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile((String)"Report Output File", (File)reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new AgeClassifyFineGrainedReportListener(reportOutputStream);
                listeners.add(reportListener);
            }
            catch (FileNotFoundException e) {
                throw new TerminateToolException(-1, "IO error while creating AgeClassify fine-grained report file: " + e.getMessage());
            }
        }
        AgeClassifyEvaluator evaluator = new AgeClassifyEvaluator(new AgeClassifyME(model), listeners.toArray(new AgeClassifyEvaluationMonitor[listeners.size()]));
        final PerformanceMonitor monitor = new PerformanceMonitor("doc");
        ObjectStream<AuthorAgeSample> measuredSampleStream = new ObjectStream<AuthorAgeSample>(){

            public AuthorAgeSample read() throws IOException {
                monitor.incrementCounter();
                return (AuthorAgeSample)AgeClassifyEvaluatorTool.this.sampleStream.read();
            }

            public void reset() throws IOException {
                AgeClassifyEvaluatorTool.this.sampleStream.reset();
            }

            public void close() throws IOException {
                AgeClassifyEvaluatorTool.this.sampleStream.close();
            }
        };
        monitor.startAndPrintThroughput();
        try {
            evaluator.evaluate((ObjectStream)measuredSampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                measuredSampleStream.close();
            }
            catch (IOException iOException) {}
        }
        monitor.stopAndPrintFinalResult();
        System.out.println();
        System.out.println(evaluator);
        if (reportListener != null) {
            System.out.println("Writing fine-grained report to " + ((EvalToolParams)this.params).getReportOutputFile().getAbsolutePath());
            reportListener.writeReport();
            try {
                ((OutputStream)reportOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

