/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.visitor;

import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.JavaStringMaker;
import EDU.purdue.jtb.misc.Spacing;
import EDU.purdue.jtb.syntaxtree.BNFProduction;
import EDU.purdue.jtb.syntaxtree.CharacterDescriptor;
import EDU.purdue.jtb.syntaxtree.CharacterList;
import EDU.purdue.jtb.syntaxtree.ComplexRegularExpression;
import EDU.purdue.jtb.syntaxtree.ComplexRegularExpressionChoices;
import EDU.purdue.jtb.syntaxtree.ComplexRegularExpressionUnit;
import EDU.purdue.jtb.syntaxtree.Expansion;
import EDU.purdue.jtb.syntaxtree.ExpansionChoices;
import EDU.purdue.jtb.syntaxtree.ExpansionUnit;
import EDU.purdue.jtb.syntaxtree.ExpansionUnitTerm;
import EDU.purdue.jtb.syntaxtree.JavaCCInput;
import EDU.purdue.jtb.syntaxtree.JavaCCOptions;
import EDU.purdue.jtb.syntaxtree.JavaCodeProduction;
import EDU.purdue.jtb.syntaxtree.LexicalStateList;
import EDU.purdue.jtb.syntaxtree.LocalLookahead;
import EDU.purdue.jtb.syntaxtree.Node;
import EDU.purdue.jtb.syntaxtree.NodeList;
import EDU.purdue.jtb.syntaxtree.NodeListOptional;
import EDU.purdue.jtb.syntaxtree.NodeOptional;
import EDU.purdue.jtb.syntaxtree.NodeSequence;
import EDU.purdue.jtb.syntaxtree.NodeToken;
import EDU.purdue.jtb.syntaxtree.OptionBinding;
import EDU.purdue.jtb.syntaxtree.Production;
import EDU.purdue.jtb.syntaxtree.RegExprKind;
import EDU.purdue.jtb.syntaxtree.RegExprSpec;
import EDU.purdue.jtb.syntaxtree.RegularExprProduction;
import EDU.purdue.jtb.syntaxtree.RegularExpression;
import EDU.purdue.jtb.syntaxtree.TokenManagerDecls;
import EDU.purdue.jtb.visitor.DepthFirstVisitor;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;

public class Printer
extends DepthFirstVisitor {
    protected PrintWriter out;
    protected int nestLevel = 0;
    protected Spacing spc;
    protected JavaStringMaker javaStringMaker;

    public Printer() {
        this(System.out);
    }

    public Printer(Writer w) {
        this(w, new Spacing(3));
    }

    public Printer(Writer w, Spacing s) {
        this.out = new PrintWriter(w);
        this.spc = s;
        this.javaStringMaker = new JavaStringMaker(this.spc);
    }

    public Printer(OutputStream o) {
        this.out = new PrintWriter(o);
        this.spc = new Spacing(3);
        this.javaStringMaker = new JavaStringMaker(this.spc);
    }

    public void setOut(Writer w) {
        this.out = new PrintWriter(w);
    }

    public void flushWriter() {
        this.out.flush();
    }

    protected String javaString(Node n) {
        return this.javaStringMaker.javaString(n);
    }

    protected void visit(NodeList n, String sep) {
        Enumeration<Node> e = n.elements();
        while (e.hasMoreElements()) {
            e.nextElement().accept(this);
            if (!e.hasMoreElements()) continue;
            this.out.print(sep);
        }
    }

    protected void visit(NodeListOptional n, String sep) {
        if (n.present()) {
            Enumeration<Node> e = n.elements();
            while (e.hasMoreElements()) {
                e.nextElement().accept(this);
                if (!e.hasMoreElements()) continue;
                this.out.print(sep);
            }
        }
    }

    protected void visit(NodeOptional n, String sep) {
        if (n.present()) {
            n.node.accept(this);
            this.out.print(sep);
        }
    }

    protected void visit(Node n1, String sep) {
        NodeSequence n = (NodeSequence)n1;
        Enumeration<Node> e = n.elements();
        while (e.hasMoreElements()) {
            e.nextElement().accept(this);
            if (!e.hasMoreElements()) continue;
            this.out.print(sep);
        }
    }

    protected void visit(NodeToken n, String sep) {
        this.out.print(n.tokenImage + sep);
    }

    public void visit(NodeToken n) {
        this.out.print(n.tokenImage);
    }

    public void visit(JavaCCInput n) {
        this.out.print(this.spc.spc);
        n.f0.accept(this);
        this.out.println("\n");
        this.out.println(this.spc.spc + n.f1 + n.f2 + n.f3 + n.f4);
        this.out.println(this.spc.spc + this.javaString(n.f5));
        this.out.println(this.spc.spc + n.f6 + n.f7 + n.f8 + n.f9 + "\n");
        this.out.print(this.spc.spc);
        this.visit(n.f10, "\n\n" + this.spc.spc);
        this.out.println();
        this.flushWriter();
    }

    public void visit(JavaCCOptions n) {
        if (n.f0.present()) {
            NodeSequence seq = (NodeSequence)n.f0.node;
            NodeListOptional nlo = (NodeListOptional)seq.elementAt(2);
            this.out.println(seq.elementAt(0) + " " + seq.elementAt(1));
            if (nlo.present()) {
                this.spc.updateSpc(1);
                this.out.print(this.spc.spc);
                this.visit(nlo, "\n" + this.spc.spc);
                this.out.println();
                this.spc.updateSpc(-1);
            }
            this.out.print(this.spc.spc + seq.elementAt(3));
        }
    }

    public void visit(OptionBinding n) {
        n.f0.accept(this);
        this.out.print(" " + n.f1 + " ");
        n.f2.accept(this);
        n.f3.accept(this);
    }

    public void visit(Production n) {
        n.f0.accept(this);
    }

    public void visit(JavaCodeProduction n) {
        this.out.println(n.f0);
        this.out.println(this.spc.spc + this.javaString(n.f1) + " " + n.f2 + this.javaString(n.f3));
        this.out.print(this.spc.spc + this.javaString(n.f4));
    }

    public void visit(BNFProduction n) {
        this.nestLevel = 0;
        this.out.println(this.javaString(n.f0) + " " + n.f1 + this.javaString(n.f2) + " " + n.f3);
        this.out.println(this.spc.spc + this.javaString(n.f5));
        this.out.println(this.spc.spc + n.f7);
        this.spc.updateSpc(1);
        this.out.print(this.spc.spc);
        n.f8.accept(this);
        this.out.println();
        this.spc.updateSpc(-1);
        this.out.print(this.spc.spc + n.f9);
    }

    public void visit(RegularExprProduction n) {
        this.visit(n.f0, " ");
        n.f1.accept(this);
        this.out.print(" ");
        this.visit(n.f2, " ");
        this.out.println(n.f3);
        this.out.println(this.spc.spc + n.f4);
        this.spc.updateSpc(1);
        this.out.print(this.spc.spc);
        n.f5.accept(this);
        this.out.println();
        if (n.f6.present()) {
            this.out.print(this.spc.spc);
            Enumeration<Node> e = n.f6.elements();
            while (e.hasMoreElements()) {
                NodeSequence seq = (NodeSequence)e.nextElement();
                this.out.print(seq.elementAt(0) + " ");
                seq.elementAt(1).accept(this);
                this.out.println();
                if (!e.hasMoreElements()) continue;
                this.out.print(this.spc.spc);
            }
        }
        this.spc.updateSpc(-1);
        this.out.print(this.spc.spc);
        n.f7.accept(this);
    }

    public void visit(TokenManagerDecls n) {
        n.f0.accept(this);
        n.f1.accept(this);
        this.out.println(this.spc.spc + this.javaString(n.f2));
    }

    public void visit(LexicalStateList n) {
        if (n.f0.which == 0) {
            n.f0.accept(this);
        } else {
            NodeSequence seq = (NodeSequence)n.f0.choice;
            NodeListOptional nlo = (NodeListOptional)seq.elementAt(2);
            this.out.print(seq.elementAt(0).toString() + seq.elementAt(1).toString());
            if (nlo.present()) {
                Enumeration<Node> e = nlo.elements();
                while (e.hasMoreElements()) {
                    NodeSequence seq1 = (NodeSequence)e.nextElement();
                    this.out.print(seq1.elementAt(0) + " " + seq1.elementAt(1));
                }
            }
            this.out.print(seq.elementAt(3));
        }
    }

    public void visit(RegExprKind n) {
        n.f0.accept(this);
    }

    public void visit(RegExprSpec n) {
        n.f0.accept(this);
        if (n.f1.present()) {
            this.out.println();
            this.spc.updateSpc(1);
            this.out.print(this.spc.spc + this.javaString(n.f1.node));
            this.spc.updateSpc(-1);
        }
        if (n.f2.present()) {
            NodeSequence seq = (NodeSequence)n.f2.node;
            this.out.print(" " + seq.elementAt(0) + " " + seq.elementAt(1));
        }
    }

    public void visit(ExpansionChoices n) {
        if (!n.f1.present()) {
            n.f0.accept(this);
        } else {
            ++this.nestLevel;
            n.f0.accept(this);
            --this.nestLevel;
            Enumeration<Node> e = n.f1.elements();
            while (e.hasMoreElements()) {
                NodeSequence seq = (NodeSequence)e.nextElement();
                if (this.nestLevel != 0) {
                    this.out.print(" ");
                } else {
                    this.out.println();
                    this.out.print(this.spc.spc);
                }
                this.out.print(seq.elementAt(0) + " ");
                ++this.nestLevel;
                seq.elementAt(1).accept(this);
                --this.nestLevel;
            }
        }
    }

    public void visit(Expansion n) {
        if (this.nestLevel == 0) {
            this.visit(n.f0, "\n" + this.spc.spc);
        } else {
            this.visit(n.f0, " ");
        }
    }

    public void visit(ExpansionUnit n) {
        switch (n.f0.which) {
            case 0: {
                n.f0.accept(this);
                break;
            }
            case 1: {
                this.out.println();
                this.out.print(this.spc.spc);
                this.out.print(this.javaString(n.f0.choice));
                this.out.println();
                this.out.print(this.spc.spc);
                break;
            }
            case 2: {
                NodeSequence seq = (NodeSequence)n.f0.choice;
                this.out.print(seq.elementAt(0) + " ");
                ++this.nestLevel;
                seq.elementAt(1).accept(this);
                --this.nestLevel;
                this.out.print(" " + seq.elementAt(2));
                seq.elementAt(3).accept(this);
                break;
            }
            case 3: {
                NodeSequence seq = (NodeSequence)n.f0.choice;
                this.out.print(seq.elementAt(0) + " ");
                ++this.nestLevel;
                seq.elementAt(1).accept(this);
                --this.nestLevel;
                this.out.print(" " + seq.elementAt(2));
                break;
            }
            case 4: {
                n.f0.accept(this);
                break;
            }
            default: {
                Errors.hardErr("n.f0.which = " + String.valueOf(n.f0.which));
            }
        }
    }

    public void visit(ExpansionUnitTerm n) {
        n.f0.accept(this);
    }

    public void visit(LocalLookahead n) {
        this.out.print(n.f0.toString() + n.f1.toString());
        n.f2.accept(this);
        this.visit(n.f3, " ");
        ++this.nestLevel;
        n.f4.accept(this);
        --this.nestLevel;
        this.visit(n.f5, " ");
        if (n.f6.present()) {
            NodeSequence seq = (NodeSequence)n.f6.node;
            this.out.print(seq.elementAt(0) + " " + this.javaString(seq.elementAt(1)) + " " + seq.elementAt(2));
        }
        n.f7.accept(this);
    }

    public void visit(RegularExpression n) {
        if (n.f0.which != 1) {
            n.f0.accept(this);
        } else {
            NodeSequence seq = (NodeSequence)n.f0.choice;
            NodeOptional opt = (NodeOptional)seq.elementAt(1);
            seq.elementAt(0).accept(this);
            if (opt.present()) {
                NodeSequence seq1 = (NodeSequence)opt.node;
                seq1.elementAt(0).accept(this);
                this.out.print(seq1.elementAt(1).toString() + seq1.elementAt(2).toString() + " ");
            }
            seq.elementAt(2).accept(this);
            seq.elementAt(3).accept(this);
        }
    }

    public void visit(ComplexRegularExpressionChoices n) {
        n.f0.accept(this);
        Enumeration<Node> e = n.f1.elements();
        while (e.hasMoreElements()) {
            this.out.print(" ");
            this.visit((NodeSequence)e.nextElement(), " ");
        }
    }

    public void visit(ComplexRegularExpression n) {
        this.visit(n.f0, " ");
    }

    public void visit(ComplexRegularExpressionUnit n) {
        n.f0.accept(this);
    }

    public void visit(CharacterList n) {
        n.f0.accept(this);
        n.f1.accept(this);
        if (n.f2.present()) {
            NodeSequence seq = (NodeSequence)n.f2.node;
            seq.elementAt(0).accept(this);
            Enumeration<Node> e = ((NodeListOptional)seq.elementAt(1)).elements();
            while (e.hasMoreElements()) {
                NodeSequence seq1 = (NodeSequence)e.nextElement();
                this.out.print(seq1.elementAt(0) + " ");
                seq1.elementAt(1).accept(this);
            }
        }
        n.f3.accept(this);
    }

    public void visit(CharacterDescriptor n) {
        n.f0.accept(this);
        n.f1.accept(this);
    }
}

