/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.robotstxt;

import edu.uci.ics.crawler4j.robotstxt.PathRule;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentDirectives {
    public static final Logger logger = LoggerFactory.getLogger(UserAgentDirectives.class);
    public Set<String> userAgents;
    private List<String> sitemap = null;
    private String preferredHost = null;
    private Double crawlDelay = null;
    private Set<PathRule> pathRules = new HashSet<PathRule>();

    public UserAgentDirectives(Set<String> userAgents) {
        this.userAgents = userAgents;
    }

    public int match(String userAgent) {
        userAgent = userAgent.toLowerCase();
        int maxLength = 0;
        for (String ua : this.userAgents) {
            if (!ua.equals("*") && !userAgent.contains(ua)) continue;
            maxLength = Math.max(maxLength, ua.length());
        }
        return maxLength;
    }

    public boolean isWildcard() {
        return this.userAgents.contains("*");
    }

    public boolean isEmpty() {
        return this.pathRules.isEmpty();
    }

    public int checkAccess(String path, String userAgent) {
        if (this.match(userAgent) == 0) {
            return 3;
        }
        TreeSet<PathRule> rules = new TreeSet<PathRule>(new PathComparator(path));
        rules.addAll(this.pathRules);
        for (PathRule rule : rules) {
            if (!rule.matches(path)) continue;
            return rule.type;
        }
        return 3;
    }

    public void add(String rule, String value) {
        if (rule.equals("sitemap")) {
            if (this.sitemap == null) {
                this.sitemap = new ArrayList<String>();
            }
            this.sitemap.add(value);
        } else if (rule.equals("crawl-delay")) {
            try {
                this.crawlDelay = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid number format for crawl-delay robots.txt: {}", (Object)value);
            }
        } else if (rule.equals("host")) {
            this.preferredHost = value;
        } else if (rule.equals("allow")) {
            this.pathRules.add(new PathRule(1, value));
        } else if (rule.equals("disallow")) {
            this.pathRules.add(new PathRule(2, value));
        } else {
            logger.error("Invalid key in robots.txt passed to UserAgentRules: {}", (Object)rule);
        }
    }

    public Double getCrawlDelay() {
        return this.crawlDelay;
    }

    public String getPreferredHost() {
        return this.preferredHost;
    }

    public List<String> getSitemap() {
        return this.sitemap;
    }

    public static class UserAgentComparator
    implements Comparator<UserAgentDirectives> {
        String crawlUserAgent;

        UserAgentComparator(String myUA) {
            this.crawlUserAgent = myUA;
        }

        @Override
        public int compare(UserAgentDirectives lhs, UserAgentDirectives rhs) {
            int matchRhs;
            int matchLhs = lhs.match(this.crawlUserAgent);
            if (matchLhs != (matchRhs = rhs.match(this.crawlUserAgent))) {
                return Integer.compare(matchRhs, matchLhs);
            }
            if (lhs.userAgents.size() != rhs.userAgents.size()) {
                return Integer.compare(lhs.userAgents.size(), rhs.userAgents.size());
            }
            Iterator<String> i1 = lhs.userAgents.iterator();
            Iterator<String> i2 = rhs.userAgents.iterator();
            while (i1.hasNext()) {
                String ua2;
                String ua1 = i1.next();
                int order = ua1.compareTo(ua2 = i2.next());
                if (order == 0) continue;
                return order;
            }
            return 0;
        }
    }

    static class PathComparator
    implements Comparator<PathRule> {
        String path;

        PathComparator(String path) {
            this.path = path;
        }

        @Override
        public int compare(PathRule lhs, PathRule rhs) {
            boolean p1Match = lhs.matches(this.path);
            boolean p2Match = rhs.matches(this.path);
            if (p1Match && !p2Match) {
                return -1;
            }
            if (p2Match && !p1Match) {
                return 1;
            }
            String p1 = lhs.pattern.toString();
            String p2 = rhs.pattern.toString();
            if (p1.length() != p2.length()) {
                return Integer.compare(p2.length(), p1.length());
            }
            return p1.compareTo(p2);
        }
    }
}

