/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.parser;

import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.crawler.Page;
import edu.uci.ics.crawler4j.crawler.exceptions.ParseException;
import edu.uci.ics.crawler4j.parser.BinaryParseData;
import edu.uci.ics.crawler4j.parser.HtmlParseData;
import edu.uci.ics.crawler4j.parser.HtmlParser;
import edu.uci.ics.crawler4j.parser.NotAllowedContentException;
import edu.uci.ics.crawler4j.parser.TextParseData;
import edu.uci.ics.crawler4j.parser.TikaHtmlParser;
import edu.uci.ics.crawler4j.util.Net;
import edu.uci.ics.crawler4j.util.Util;
import org.apache.tika.language.LanguageIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger logger = LoggerFactory.getLogger(Parser.class);
    private final CrawlConfig config;
    private final HtmlParser htmlContentParser;

    public Parser(CrawlConfig config) throws IllegalAccessException, InstantiationException {
        this.config = config;
        this.htmlContentParser = new TikaHtmlParser(config);
    }

    public Parser(CrawlConfig config, HtmlParser htmlParser) {
        this.config = config;
        this.htmlContentParser = htmlParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(Page page, String contextURL) throws NotAllowedContentException, ParseException {
        if (Util.hasBinaryContent(page.getContentType())) {
            BinaryParseData parseData = new BinaryParseData();
            if (!this.config.isIncludeBinaryContentInCrawling()) throw new NotAllowedContentException();
            if (this.config.isProcessBinaryContentInCrawling()) {
                parseData.setBinaryContent(page.getContentData());
            } else {
                parseData.setHtml("<html></html>");
            }
            page.setParseData(parseData);
            if (parseData.getHtml() == null) {
                throw new ParseException();
            }
            parseData.setOutgoingUrls(Net.extractUrls(parseData.getHtml()));
            return;
        } else if (Util.hasPlainTextContent(page.getContentType())) {
            try {
                TextParseData parseData = new TextParseData();
                if (page.getContentCharset() == null) {
                    parseData.setTextContent(new String(page.getContentData()));
                } else {
                    parseData.setTextContent(new String(page.getContentData(), page.getContentCharset()));
                }
                parseData.setOutgoingUrls(Net.extractUrls(parseData.getTextContent()));
                page.setParseData(parseData);
                return;
            }
            catch (Exception e) {
                logger.error("{}, while parsing: {}", (Object)e.getMessage(), (Object)page.getWebURL().getURL());
                throw new ParseException();
            }
        } else {
            HtmlParseData parsedData = this.htmlContentParser.parse(page, contextURL);
            if (page.getContentCharset() == null) {
                page.setContentCharset(parsedData.getContentCharset());
            }
            LanguageIdentifier languageIdentifier = new LanguageIdentifier(parsedData.getText());
            page.setLanguage(languageIdentifier.getLanguage());
            page.setParseData(parsedData);
        }
    }
}

