/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.frontier;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import edu.uci.ics.crawler4j.frontier.WebURLTupleBinding;
import edu.uci.ics.crawler4j.url.WebURL;
import edu.uci.ics.crawler4j.util.Util;
import java.util.ArrayList;
import java.util.List;

public class WorkQueues {
    private final Database urlsDB;
    private final Environment env;
    private final boolean resumable;
    private final WebURLTupleBinding webURLBinding;
    protected final Object mutex = new Object();

    public WorkQueues(Environment env, String dbName, boolean resumable) {
        this.env = env;
        this.resumable = resumable;
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(resumable);
        dbConfig.setDeferredWrite(!resumable);
        this.urlsDB = env.openDatabase(null, dbName, dbConfig);
        this.webURLBinding = new WebURLTupleBinding();
    }

    protected Transaction beginTransaction() {
        return this.resumable ? this.env.beginTransaction(null, null) : null;
    }

    protected static void commit(Transaction tnx) {
        if (tnx != null) {
            tnx.commit();
        }
    }

    protected Cursor openCursor(Transaction txn) {
        return this.urlsDB.openCursor(txn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebURL> get(int max) {
        Object object = this.mutex;
        synchronized (object) {
            ArrayList<WebURL> results = new ArrayList<WebURL>(max);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            Transaction txn = this.beginTransaction();
            try (Cursor cursor = this.openCursor(txn);){
                OperationStatus result = cursor.getFirst(key, value, null);
                int matches = 0;
                while (matches < max && result == OperationStatus.SUCCESS) {
                    if (value.getData().length > 0) {
                        results.add((WebURL)this.webURLBinding.entryToObject(value));
                        ++matches;
                    }
                    result = cursor.getNext(key, value, null);
                }
            }
            WorkQueues.commit(txn);
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int count) {
        Object object = this.mutex;
        synchronized (object) {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            Transaction txn = this.beginTransaction();
            try (Cursor cursor = this.openCursor(txn);){
                OperationStatus result = cursor.getFirst(key, value, null);
                for (int matches = 0; matches < count && result == OperationStatus.SUCCESS; ++matches) {
                    cursor.delete();
                    result = cursor.getNext(key, value, null);
                }
            }
            WorkQueues.commit(txn);
        }
    }

    protected static DatabaseEntry getDatabaseEntryKey(WebURL url) {
        byte[] keyData = new byte[6];
        keyData[0] = url.getPriority();
        keyData[1] = (byte)(url.getDepth() > 127 ? 127 : (byte)url.getDepth());
        Util.putIntInByteArray(url.getDocid(), keyData, 2);
        return new DatabaseEntry(keyData);
    }

    public void put(WebURL url) {
        DatabaseEntry value = new DatabaseEntry();
        this.webURLBinding.objectToEntry(url, value);
        Transaction txn = this.beginTransaction();
        this.urlsDB.put(txn, WorkQueues.getDatabaseEntryKey(url), value);
        WorkQueues.commit(txn);
    }

    public long getLength() {
        return this.urlsDB.count();
    }

    public void close() {
        this.urlsDB.close();
    }
}

