/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.frontier;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Counters {
    private static final Logger logger = LoggerFactory.getLogger(Counters.class);
    private static final String DATABASE_NAME = "Statistics";
    protected Database statisticsDB = null;
    protected Environment env;
    protected final Object mutex = new Object();
    protected Map<String, Long> counterValues;

    public Counters(Environment env, CrawlConfig config) {
        this.env = env;
        this.counterValues = new HashMap<String, Long>();
        if (config.isResumableCrawling()) {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(true);
            dbConfig.setDeferredWrite(false);
            this.statisticsDB = env.openDatabase(null, DATABASE_NAME, dbConfig);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            Transaction tnx = env.beginTransaction(null, null);
            Cursor cursor = this.statisticsDB.openCursor(tnx, null);
            OperationStatus result = cursor.getFirst(key, value, null);
            while (result == OperationStatus.SUCCESS) {
                if (value.getData().length > 0) {
                    String name = new String(key.getData());
                    long counterValue = Util.byteArray2Long(value.getData());
                    this.counterValues.put(name, counterValue);
                }
                result = cursor.getNext(key, value, null);
            }
            cursor.close();
            tnx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getValue(String name) {
        Object object = this.mutex;
        synchronized (object) {
            Long value = this.counterValues.get(name);
            if (value == null) {
                return 0L;
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String name, long value) {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.counterValues.put(name, value);
                if (this.statisticsDB != null) {
                    Transaction txn = this.env.beginTransaction(null, null);
                    this.statisticsDB.put(txn, new DatabaseEntry(name.getBytes()), new DatabaseEntry(Util.long2ByteArray(value)));
                    txn.commit();
                }
            }
            catch (Exception e) {
                logger.error("Exception setting value", (Throwable)e);
            }
        }
    }

    public void increment(String name) {
        this.increment(name, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(String name, long addition) {
        Object object = this.mutex;
        synchronized (object) {
            long prevValue = this.getValue(name);
            this.setValue(name, prevValue + addition);
        }
    }

    public void close() {
        try {
            if (this.statisticsDB != null) {
                this.statisticsDB.close();
            }
        }
        catch (DatabaseException e) {
            logger.error("Exception thrown while trying to close statisticsDB", (Throwable)e);
        }
    }

    public static class ReservedCounterNames {
        public static final String SCHEDULED_PAGES = "Scheduled-Pages";
        public static final String PROCESSED_PAGES = "Processed-Pages";
    }
}

