/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.url;

import edu.uci.ics.crawler4j.url.UrlResolver;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class URLCanonicalizer {
    public static String getCanonicalURL(String url) {
        return URLCanonicalizer.getCanonicalURL(url, null);
    }

    public static String getCanonicalURL(String href, String context) {
        try {
            int port;
            String canonicalParams;
            URL canonicalURL = new URL(UrlResolver.resolveUrl(context == null ? "" : context, href));
            String host = canonicalURL.getHost().toLowerCase();
            if (Objects.equals(host, "")) {
                return null;
            }
            String path = canonicalURL.getPath();
            path = new URI(path.replace("\\", "/")).normalize().toString();
            int idx = path.indexOf("//");
            while (idx >= 0) {
                path = path.replace("//", "/");
                idx = path.indexOf("//");
            }
            while (path.startsWith("/../")) {
                path = path.substring(3);
            }
            path = path.trim();
            Map<String, String> params = URLCanonicalizer.createParameterMap(canonicalURL.getQuery());
            String queryString = params != null && !params.isEmpty() ? ((canonicalParams = URLCanonicalizer.canonicalize(params)).isEmpty() ? "" : "?" + canonicalParams) : "";
            if (path.isEmpty()) {
                path = "/";
            }
            if ((port = canonicalURL.getPort()) == canonicalURL.getDefaultPort()) {
                port = -1;
            }
            String protocol = canonicalURL.getProtocol().toLowerCase();
            String pathAndQueryString = URLCanonicalizer.normalizePath(path) + queryString;
            URL result = new URL(protocol, host, port, pathAndQueryString);
            return result.toExternalForm();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            return null;
        }
    }

    private static Map<String, String> createParameterMap(String queryString) {
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        String[] pairs = queryString.split("&");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(pairs.length);
        block4: for (String pair : pairs) {
            if (pair.isEmpty()) continue;
            String[] tokens = pair.split("=", 2);
            switch (tokens.length) {
                case 1: {
                    if (pair.charAt(0) == '=') {
                        params.put("", tokens[0]);
                        continue block4;
                    }
                    params.put(tokens[0], "");
                    continue block4;
                }
                case 2: {
                    params.put(tokens[0], tokens[1]);
                }
            }
        }
        return new LinkedHashMap<String, String>(params);
    }

    private static String canonicalize(Map<String, String> paramsMap) {
        if (paramsMap == null || paramsMap.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(100);
        for (Map.Entry<String, String> pair : paramsMap.entrySet()) {
            String key = pair.getKey().toLowerCase();
            if ("jsessionid".equals(key) || "phpsessid".equals(key) || "aspsessionid".equals(key)) continue;
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(URLCanonicalizer.percentEncodeRfc3986(pair.getKey()));
            if (pair.getValue().isEmpty()) continue;
            sb.append('=');
            sb.append(URLCanonicalizer.percentEncodeRfc3986(pair.getValue()));
        }
        return sb.toString();
    }

    private static String percentEncodeRfc3986(String string) {
        try {
            string = string.replace("+", "%2B");
            string = URLDecoder.decode(string, "UTF-8");
            string = URLEncoder.encode(string, "UTF-8");
            return string.replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (Exception e) {
            return string;
        }
    }

    private static String normalizePath(String path) {
        return path.replace("%7E", "~").replace(" ", "%20");
    }
}

