/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.robotstxt;

import edu.uci.ics.crawler4j.robotstxt.RobotstxtConfig;
import edu.uci.ics.crawler4j.robotstxt.UserAgentDirectives;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class HostDirectives {
    private static final long EXPIRATION_DELAY = 1440000L;
    public static final int ALLOWED = 1;
    public static final int DISALLOWED = 2;
    public static final int UNDEFINED = 3;
    private Set<UserAgentDirectives> rules;
    private final long timeFetched = System.currentTimeMillis();
    private long timeLastAccessed;
    private RobotstxtConfig config;
    private String userAgent;

    public HostDirectives(RobotstxtConfig configuration) {
        this.config = configuration;
        this.userAgent = this.config.getUserAgentName().toLowerCase();
        this.rules = new TreeSet<UserAgentDirectives>(new UserAgentDirectives.UserAgentComparator(this.userAgent));
    }

    public boolean needsRefetch() {
        return System.currentTimeMillis() - this.timeFetched > 1440000L;
    }

    public boolean allows(String path) {
        return this.checkAccess(path) != 2;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent.toLowerCase();
        TreeSet<UserAgentDirectives> replace = new TreeSet<UserAgentDirectives>(new UserAgentDirectives.UserAgentComparator(this.userAgent));
        replace.addAll(this.rules);
        this.rules = replace;
    }

    public boolean disallows(String path) {
        return this.checkAccess(path) == 2;
    }

    public int checkAccess(String path) {
        UserAgentDirectives ua;
        int score;
        this.timeLastAccessed = System.currentTimeMillis();
        int result = 3;
        String myUA = this.config.getUserAgentName();
        boolean ignoreUADisc = this.config.getIgnoreUADiscrimination();
        Iterator<UserAgentDirectives> iterator = this.rules.iterator();
        while (iterator.hasNext() && ((score = (ua = iterator.next()).match(myUA)) != 0 || ignoreUADisc) && (result = ua.checkAccess(path, this.userAgent)) == 2 && ua.isWildcard() && ignoreUADisc) {
        }
        return result;
    }

    public void addDirectives(UserAgentDirectives directives) {
        this.rules.add(directives);
    }

    public long getLastAccessTime() {
        return this.timeLastAccessed;
    }
}

