/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.fetcher;

import java.io.IOException;
import javax.net.ssl.SSLProtocolException;
import org.apache.http.HttpClientConnection;
import org.apache.http.config.Registry;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SniPoolingHttpClientConnectionManager
extends PoolingHttpClientConnectionManager {
    public static final Logger logger = LoggerFactory.getLogger(SniPoolingHttpClientConnectionManager.class);

    public SniPoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry) {
        super(socketFactoryRegistry);
    }

    public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
        try {
            super.connect(conn, route, connectTimeout, context);
        }
        catch (SSLProtocolException e) {
            boolean enableSni;
            Boolean enableSniValue = (Boolean)context.getAttribute("__enable_sni__");
            boolean bl = enableSni = enableSniValue == null || enableSniValue != false;
            if (enableSni && e.getMessage() != null && e.getMessage().equals("handshake alert:  unrecognized_name")) {
                logger.warn("Server saw wrong SNI host, retrying without SNI");
                context.setAttribute("__enable_sni__", (Object)false);
                super.connect(conn, route, connectTimeout, context);
            }
            throw e;
        }
    }
}

