/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.parser;

import edu.uci.ics.crawler4j.parser.ExtractedUrlAnchorPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HtmlContentHandler
extends DefaultHandler {
    private static final int MAX_ANCHOR_LENGTH = 100;
    private String base;
    private String metaRefresh;
    private String metaLocation;
    private final Map<String, String> metaTags = new HashMap<String, String>();
    private boolean isWithinBodyElement = false;
    private final StringBuilder bodyText;
    private final List<ExtractedUrlAnchorPair> outgoingUrls;
    private ExtractedUrlAnchorPair curUrl = null;
    private boolean anchorFlag = false;
    private final StringBuilder anchorText = new StringBuilder();

    public HtmlContentHandler() {
        this.bodyText = new StringBuilder();
        this.outgoingUrls = new ArrayList<ExtractedUrlAnchorPair>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element element = HtmlFactory.getElement(localName);
        if (element == Element.A || element == Element.AREA || element == Element.LINK) {
            String href = attributes.getValue("href");
            if (href != null) {
                this.anchorFlag = true;
                this.addToOutgoingUrls(href, localName);
            }
        } else if (element == Element.IMG) {
            String imgSrc = attributes.getValue("src");
            if (imgSrc != null) {
                this.addToOutgoingUrls(imgSrc, localName);
            }
        } else if (element == Element.IFRAME || element == Element.FRAME || element == Element.EMBED) {
            String src = attributes.getValue("src");
            if (src != null) {
                this.addToOutgoingUrls(src, localName);
            }
        } else if (element == Element.BASE) {
            String href;
            if (this.base != null && (href = attributes.getValue("href")) != null) {
                this.base = href;
            }
        } else if (element == Element.META) {
            String equiv = attributes.getValue("http-equiv");
            if (equiv == null) {
                equiv = attributes.getValue("name");
            }
            String content = attributes.getValue("content");
            if (equiv != null && content != null) {
                int pos;
                equiv = equiv.toLowerCase();
                this.metaTags.put(equiv, content);
                if ("refresh".equals(equiv) && this.metaRefresh == null && (pos = content.toLowerCase().indexOf("url=")) != -1) {
                    this.metaRefresh = content.substring(pos + 4);
                    this.addToOutgoingUrls(this.metaRefresh, localName);
                }
                if ("location".equals(equiv) && this.metaLocation == null) {
                    this.metaLocation = content;
                    this.addToOutgoingUrls(this.metaLocation, localName);
                }
            }
        } else if (element == Element.BODY) {
            this.isWithinBodyElement = true;
        }
    }

    private void addToOutgoingUrls(String href, String tag) {
        this.curUrl = new ExtractedUrlAnchorPair();
        this.curUrl.setHref(href);
        this.curUrl.setTag(tag);
        this.outgoingUrls.add(this.curUrl);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Element element = HtmlFactory.getElement(localName);
        if (element == Element.A || element == Element.AREA || element == Element.LINK) {
            this.anchorFlag = false;
            if (this.curUrl != null) {
                String anchor = this.anchorText.toString().replaceAll("\n", " ").replaceAll("\t", " ").trim();
                if (!anchor.isEmpty()) {
                    if (anchor.length() > 100) {
                        anchor = anchor.substring(0, 100) + "...";
                    }
                    this.curUrl.setTag(localName);
                    this.curUrl.setAnchor(anchor);
                }
                this.anchorText.delete(0, this.anchorText.length());
            }
            this.curUrl = null;
        } else if (element == Element.BODY) {
            this.isWithinBodyElement = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isWithinBodyElement) {
            this.bodyText.append(ch, start, length);
            if (this.anchorFlag) {
                this.anchorText.append(new String(ch, start, length));
            }
        }
    }

    public String getBodyText() {
        return this.bodyText.toString();
    }

    public List<ExtractedUrlAnchorPair> getOutgoingUrls() {
        return this.outgoingUrls;
    }

    public String getBaseUrl() {
        return this.base;
    }

    public Map<String, String> getMetaTags() {
        return this.metaTags;
    }

    private static class HtmlFactory {
        private static final Map<String, Element> name2Element = new HashMap<String, Element>();

        private HtmlFactory() {
        }

        public static Element getElement(String name) {
            return name2Element.get(name);
        }

        static {
            for (Element element : Element.values()) {
                name2Element.put(element.toString().toLowerCase(), element);
            }
        }
    }

    private static enum Element {
        A,
        AREA,
        LINK,
        IFRAME,
        FRAME,
        EMBED,
        IMG,
        BASE,
        META,
        BODY;

    }
}

