/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.frontier;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import edu.uci.ics.crawler4j.frontier.WorkQueues;
import edu.uci.ics.crawler4j.url.WebURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProcessPagesDB
extends WorkQueues {
    private static final Logger logger = LoggerFactory.getLogger(InProcessPagesDB.class);
    private static final String DATABASE_NAME = "InProcessPagesDB";

    public InProcessPagesDB(Environment env) {
        super(env, DATABASE_NAME, true);
        long docCount = this.getLength();
        if (docCount > 0L) {
            logger.info("Loaded {} URLs that have been in process in the previous crawl.", (Object)docCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeURL(WebURL webUrl) {
        Object object = this.mutex;
        synchronized (object) {
            DatabaseEntry key = InProcessPagesDB.getDatabaseEntryKey(webUrl);
            DatabaseEntry value = new DatabaseEntry();
            Transaction txn = this.beginTransaction();
            try {
                boolean bl;
                Cursor cursor = this.openCursor(txn);
                Throwable throwable = null;
                try {
                    OperationStatus result = cursor.getSearchKey(key, value, null);
                    if (result != OperationStatus.SUCCESS) return false;
                    result = cursor.delete();
                    if (result != OperationStatus.SUCCESS) return false;
                    bl = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                return bl;
                finally {
                    if (cursor != null) {
                        if (throwable != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            cursor.close();
                        }
                    }
                }
            }
            finally {
                InProcessPagesDB.commit(txn);
            }
        }
    }
}

