/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.url;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLDList {
    private static final String TLD_NAMES_ONLINE_URL = "https://publicsuffix.org/list/effective_tld_names.dat";
    private static final String TLD_NAMES_TXT_FILENAME = "/tld-names.txt";
    private static final Logger logger = LoggerFactory.getLogger(TLDList.class);
    private Set<String> tldSet = new HashSet<String>(10000);
    private static TLDList instance = new TLDList();

    private TLDList() {
        try {
            URL url = new URL(TLD_NAMES_ONLINE_URL);
            try (InputStream stream = url.openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                logger.debug("Fetching the most updated TLD list online");
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("//")) continue;
                    this.tldSet.add(line);
                }
            }
            catch (Exception ex) {
                throw new Exception("Error while retrieving online TLD List");
            }
        }
        catch (Exception ex) {
            logger.warn("Couldn't fetch the online list of TLDs from: {}", (Object)TLD_NAMES_ONLINE_URL);
            logger.info("Fetching the list from my local file {}", (Object)TLD_NAMES_TXT_FILENAME);
            try (InputStream stream = this.getClass().getResourceAsStream(TLD_NAMES_TXT_FILENAME);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("//")) continue;
                    this.tldSet.add(line);
                }
            }
            catch (Exception ex2) {
                logger.error("Couldn't find /tld-names.txt", (Throwable)ex2);
                logger.error("No TLD List exiting...");
                System.exit(-1);
            }
        }
    }

    public static TLDList getInstance() {
        return instance;
    }

    public boolean contains(String str) {
        return this.tldSet.contains(str);
    }
}

