/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.frontier;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import edu.uci.ics.crawler4j.crawler.Configurable;
import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocIDServer
extends Configurable {
    protected static final Logger logger = LoggerFactory.getLogger(DocIDServer.class);
    protected Database docIDsDB = null;
    protected final Object mutex = new Object();
    protected int lastDocID;

    public DocIDServer(Environment env, CrawlConfig config) throws DatabaseException {
        super(config);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(config.isResumableCrawling());
        dbConfig.setDeferredWrite(!config.isResumableCrawling());
        this.docIDsDB = env.openDatabase(null, "DocIDs", dbConfig);
        if (config.isResumableCrawling()) {
            int docCount = this.getDocCount();
            if (docCount > 0) {
                logger.info("Loaded {} URLs that had been detected in previous crawl.", (Object)docCount);
                this.lastDocID = docCount;
            }
        } else {
            this.lastDocID = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDocId(String url) {
        Object object = this.mutex;
        synchronized (object) {
            int docID = -1;
            if (this.docIDsDB != null) {
                OperationStatus result = null;
                DatabaseEntry value = new DatabaseEntry();
                try {
                    DatabaseEntry key = new DatabaseEntry(url.getBytes());
                    result = this.docIDsDB.get(null, key, value, null);
                }
                catch (Exception e) {
                    logger.error("Exception thrown while getting DocID", (Throwable)e);
                }
                if (result != null && result == OperationStatus.SUCCESS && value.getData().length > 0) {
                    docID = Util.byteArray2Int(value.getData());
                }
            }
            return docID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewDocID(String url) {
        int docID = -1;
        Object object = this.mutex;
        synchronized (object) {
            try {
                docID = this.getDocId(url);
                if (docID <= 0) {
                    ++this.lastDocID;
                    this.docIDsDB.put(null, new DatabaseEntry(url.getBytes()), new DatabaseEntry(Util.int2ByteArray(this.lastDocID)));
                    docID = this.lastDocID;
                }
            }
            catch (Exception e) {
                logger.error("Exception thrown while getting new DocID", (Throwable)e);
            }
            return docID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUrlAndDocId(String url, int docId) throws Exception {
        Object object = this.mutex;
        synchronized (object) {
            if (docId <= this.lastDocID) {
                throw new Exception("Requested doc id: " + docId + " is not larger than: " + this.lastDocID);
            }
            int prevDocid = this.getDocId(url);
            if (prevDocid > 0) {
                if (prevDocid == docId) {
                    return;
                }
                throw new Exception("Doc id: " + prevDocid + " is already assigned to URL: " + url);
            }
            this.docIDsDB.put(null, new DatabaseEntry(url.getBytes()), new DatabaseEntry(Util.int2ByteArray(docId)));
            this.lastDocID = docId;
        }
    }

    public boolean isSeenBefore(String url) {
        return this.getDocId(url) != -1;
    }

    public int getDocCount() {
        int count = -1;
        try {
            count = (int)this.docIDsDB.count();
        }
        catch (DatabaseException e) {
            logger.error("Exception thrown while getting DOC Count", (Throwable)e);
        }
        return count;
    }

    public void close() {
        try {
            this.docIDsDB.close();
        }
        catch (DatabaseException e) {
            logger.error("Exception thrown while closing DocIDServer", (Throwable)e);
        }
    }
}

