/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.fetcher;

import edu.uci.ics.crawler4j.crawler.Page;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageFetchResult {
    protected static final Logger logger = LoggerFactory.getLogger(PageFetchResult.class);
    protected int statusCode;
    protected HttpEntity entity = null;
    protected Header[] responseHeaders = null;
    protected String fetchedUrl = null;
    protected String movedToUrl = null;

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    public Header[] getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Header[] responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public String getFetchedUrl() {
        return this.fetchedUrl;
    }

    public void setFetchedUrl(String fetchedUrl) {
        this.fetchedUrl = fetchedUrl;
    }

    public boolean fetchContent(Page page) {
        try {
            page.load(this.entity);
            page.setFetchResponseHeaders(this.responseHeaders);
            return true;
        }
        catch (Exception e) {
            logger.info("Exception while fetching content for: {} [{}]", (Object)page.getWebURL().getURL(), (Object)e.getMessage());
            return false;
        }
    }

    public void discardContentIfNotConsumed() {
        try {
            if (this.entity != null) {
                EntityUtils.consume((HttpEntity)this.entity);
            }
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            logger.warn("Unexpected error occurred while trying to discard content", (Throwable)e);
        }
    }

    public String getMovedToUrl() {
        return this.movedToUrl;
    }

    public void setMovedToUrl(String movedToUrl) {
        this.movedToUrl = movedToUrl;
    }
}

