/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import javax.annotation.concurrent.Immutable;
import ucar.units.BaseQuantity;
import ucar.units.Dimension;
import ucar.units.Factor;

@Immutable
public final class QuantityDimension
extends Dimension {
    public QuantityDimension() {
    }

    public QuantityDimension(BaseQuantity baseQuantity) {
        super(new Factor(baseQuantity));
    }

    protected QuantityDimension(Factor[] factors) {
        super(factors);
    }

    public QuantityDimension multiplyBy(QuantityDimension that) {
        return new QuantityDimension(this.mult(that));
    }

    public QuantityDimension divideBy(QuantityDimension that) {
        return this.multiplyBy(that.raiseTo(-1));
    }

    public QuantityDimension raiseTo(int power) {
        return new QuantityDimension(this.pow(power));
    }

    public static void main(String[] args) throws Exception {
        System.out.println("new QuantityDimension() = \"" + new QuantityDimension() + '\"');
        QuantityDimension timeDimension = new QuantityDimension(BaseQuantity.TIME);
        System.out.println("timeDimension = \"" + timeDimension + '\"');
        QuantityDimension lengthDimension = new QuantityDimension(BaseQuantity.LENGTH);
        System.out.println("lengthDimension = \"" + lengthDimension + '\"');
        System.out.println("lengthDimension.isReciprocalOf(timeDimension) = \"" + lengthDimension.isReciprocalOf(timeDimension) + '\"');
        QuantityDimension hertzDimension = timeDimension.raiseTo(-1);
        System.out.println("hertzDimension = \"" + hertzDimension + '\"');
        System.out.println("hertzDimension.isReciprocalOf(timeDimension) = \"" + hertzDimension.isReciprocalOf(timeDimension) + '\"');
        System.out.println("lengthDimension.divideBy(timeDimension) = \"" + lengthDimension.divideBy(timeDimension) + '\"');
        System.out.println("lengthDimension.divideBy(timeDimension).raiseTo(2) = \"" + lengthDimension.divideBy(timeDimension).raiseTo(2) + '\"');
    }
}

