/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import ucar.mcidas.AreaDirectory;
import ucar.mcidas.AreaFileException;
import ucar.mcidas.McIDASUtil;

public class AreaDirectoryList {
    private static boolean debug = false;
    private boolean flipwords;
    private DataInputStream inputStream;
    private int status;
    private URLConnection urlc;
    private boolean isADDE;
    private int[] dir;
    private Date[] nominalTimes;
    private int[] bands;
    private int[] lines;
    private int[] elements;
    private ArrayList dirs;
    private int numDirs;

    public AreaDirectoryList(String imageSource) throws AreaFileException {
        block4: {
            this.flipwords = false;
            this.status = 0;
            this.isADDE = false;
            this.numDirs = 0;
            try {
                this.inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(imageSource), 2048));
            }
            catch (IOException eIO) {
                URL url;
                try {
                    url = new URL(imageSource);
                    this.urlc = url.openConnection();
                    InputStream is = this.urlc.getInputStream();
                    this.inputStream = new DataInputStream(new BufferedInputStream(is));
                }
                catch (Exception e) {
                    throw new AreaFileException("Error opening AreaFile", e);
                }
                if (!url.getProtocol().equalsIgnoreCase("adde")) break block4;
                this.isADDE = true;
            }
        }
        this.readDirectory();
    }

    public AreaDirectoryList(URL url) throws AreaFileException {
        this.flipwords = false;
        this.status = 0;
        this.isADDE = false;
        this.numDirs = 0;
        try {
            this.inputStream = new DataInputStream(new BufferedInputStream(url.openStream()));
        }
        catch (IOException e) {
            throw new AreaFileException("Error opening URL for AreaFile", e);
        }
        this.readDirectory();
    }

    private void readDirectory() throws AreaFileException {
        double resolutionLat = Double.NaN;
        double resolutionLon = Double.NaN;
        double centerLat = Double.NaN;
        double centerLon = Double.NaN;
        int band = 0;
        String calname = " ";
        String caldesc = " ";
        this.dirs = new ArrayList();
        int numBytes = 64;
        while (numBytes > 0) {
            try {
                int i;
                this.dir = new int[64];
                if (this.isADDE) {
                    int areaNumber = this.inputStream.readInt();
                    if (debug) {
                        System.out.println("Area number = " + areaNumber);
                    }
                }
                for (i = 0; i < 64; ++i) {
                    this.dir[i] = this.inputStream.readInt();
                }
                if (!this.isADDE) {
                    this.dir[0] = 0;
                }
                if (this.dir[1] > 255 || this.flipwords) {
                    this.flipwords = true;
                    McIDASUtil.flip(this.dir, 0, 19);
                    if ((this.dir[20] & 0xFFFF) == 0) {
                        McIDASUtil.flip(this.dir, 20, 20);
                    }
                    McIDASUtil.flip(this.dir, 21, 23);
                    McIDASUtil.flip(this.dir, 32, 50);
                    McIDASUtil.flip(this.dir, 53, 55);
                    McIDASUtil.flip(this.dir, 57, 63);
                }
                if (debug) {
                    for (i = 0; i < 64; ++i) {
                        System.out.println("dir[" + i + "] = " + this.dir[i]);
                    }
                }
                AreaDirectory ad = new AreaDirectory(this.dir);
                int[] bands = ad.getBands();
                int numBands = ad.getNumberOfBands();
                Vector[] calInfo = new Vector[numBands];
                for (int k = 0; k < numBands; ++k) {
                    calInfo[k] = new Vector();
                }
                if (!this.isADDE) {
                    numBytes = 0;
                } else {
                    int numCards = this.dir[63];
                    if (debug) {
                        System.out.println("Number of comment cards = " + numCards);
                    }
                    for (int i2 = 0; i2 < numCards; ++i2) {
                        int k;
                        int m3;
                        byte[] card = new byte[80];
                        int count = 0;
                        boolean prevBlank = true;
                        for (int j = 0; j < 80; ++j) {
                            byte b = this.inputStream.readByte();
                            if (b == 32) {
                                if (!prevBlank) {
                                    card[count++] = b;
                                    prevBlank = false;
                                }
                                prevBlank = true;
                                continue;
                            }
                            card[count++] = b;
                            prevBlank = false;
                        }
                        String cd2 = new String(card, 0, count).trim();
                        if (debug) {
                            System.out.println("card[" + i2 + "] = " + cd2);
                        }
                        if (cd2.indexOf("Center latitude") > -1) {
                            m3 = cd2.indexOf("=");
                            if (m3 > 0) {
                                centerLat = Double.valueOf(cd2.substring(m3 + 1).trim());
                                continue;
                            }
                            centerLat = Double.NaN;
                            continue;
                        }
                        if (cd2.indexOf("Center longitude") > -1) {
                            m3 = cd2.indexOf("=");
                            if (m3 > 0) {
                                centerLon = -Double.valueOf(cd2.substring(m3 + 1).trim()).doubleValue();
                                continue;
                            }
                            centerLon = Double.NaN;
                            continue;
                        }
                        if (cd2.indexOf("Computed Latitude") > -1) {
                            m3 = cd2.indexOf("=");
                            if (m3 > 0) {
                                resolutionLat = Double.valueOf(cd2.substring(m3 + 1).trim());
                                continue;
                            }
                            resolutionLat = Double.NaN;
                            continue;
                        }
                        if (cd2.indexOf("Computed Longitude") > -1) {
                            m3 = cd2.indexOf("=");
                            if (m3 > 0) {
                                resolutionLon = Double.valueOf(cd2.substring(m3 + 1).trim());
                                continue;
                            }
                            resolutionLon = Double.NaN;
                            continue;
                        }
                        if (cd2.indexOf("Valid calibration unit") <= -1 || (m3 = cd2.indexOf("=")) <= 0) continue;
                        String cdd = cd2.replace('\"', ' ');
                        StringTokenizer st = new StringTokenizer(cdd, " ");
                        int n = st.countTokens();
                        band = 0;
                        calname = " ";
                        caldesc = " ";
                        boolean gotit = false;
                        for (k = 0; k < n; ++k) {
                            if (!st.nextToken().trim().equals("band")) continue;
                            gotit = true;
                            break;
                        }
                        if (!gotit) continue;
                        band = Integer.parseInt(st.nextToken().trim());
                        st.nextToken();
                        caldesc = calname = st.nextToken();
                        if (st.hasMoreTokens()) {
                            StringBuffer buf = new StringBuffer();
                            while (st.hasMoreTokens()) {
                                buf.append(st.nextToken());
                                buf.append(" ");
                            }
                            caldesc = buf.toString().trim();
                        }
                        for (k = 0; k < numBands; ++k) {
                            if (band != bands[k]) continue;
                            calInfo[k].addElement(calname);
                            calInfo[k].addElement(caldesc);
                        }
                    }
                    ad.setCenterLatitude(centerLat);
                    ad.setCenterLongitude(centerLon);
                    ad.setCenterLatitudeResolution(resolutionLat);
                    ad.setCenterLongitudeResolution(resolutionLon);
                    ad.setCalInfo(calInfo);
                    numBytes = this.inputStream.readInt();
                    if (debug) {
                        System.out.println("Bytes in next record = " + numBytes);
                    }
                }
                this.dirs.add(ad);
            }
            catch (IOException e) {
                this.status = -1;
                throw new AreaFileException("Error reading Area directory:", e);
            }
            this.status = 1;
            ++this.numDirs;
        }
    }

    public AreaDirectory[][] getSortedDirs() throws AreaFileException {
        int num;
        if (this.status <= 0 || this.dirs.size() <= 0) {
            throw new AreaFileException("Error reading directory information");
        }
        Date[] dtg = new Date[this.numDirs];
        int[] pos = new int[this.numDirs];
        int[] insitu = new int[this.numDirs];
        ArrayList al = new ArrayList();
        ArrayList alt = null;
        for (int i = 0; i < this.numDirs; ++i) {
            AreaDirectory ad = (AreaDirectory)this.dirs.get(i);
            dtg[i] = ad.getNominalTime();
            pos[i] = ad.getValue(0);
            insitu[i] = i;
        }
        Date ddd = null;
        for (int i = 0; i < this.numDirs; ++i) {
            int swap = i;
            for (int k = i + 1; k < this.numDirs; ++k) {
                if (dtg[swap].compareTo(dtg[k]) <= 0) continue;
                swap = k;
            }
            if (swap != i) {
                Date dtgt = dtg[i];
                dtg[i] = dtg[swap];
                dtg[swap] = dtgt;
                int intt = pos[i];
                pos[i] = pos[swap];
                pos[swap] = intt;
                intt = insitu[i];
                insitu[i] = insitu[swap];
                insitu[swap] = intt;
            }
            if (ddd == null || ddd.compareTo(dtg[i]) != 0) {
                if (ddd != null) {
                    al.add(alt);
                }
                ddd = dtg[i];
                alt = new ArrayList();
            }
            alt.add(this.dirs.get(insitu[i]));
        }
        if (alt != null && alt.size() > 0) {
            al.add(alt);
        }
        if ((num = al.size()) == 0) {
            return null;
        }
        AreaDirectory[][] ada = new AreaDirectory[num][];
        for (int i = 0; i < num; ++i) {
            alt = (ArrayList)al.get(i);
            int knum = alt.size();
            ada[i] = new AreaDirectory[knum];
            for (int k = 0; k < knum; ++k) {
                ada[i][k] = (AreaDirectory)alt.get(k);
            }
        }
        return ada;
    }

    public ArrayList getDirs() throws AreaFileException {
        if (this.status <= 0 || this.dirs.size() <= 0) {
            throw new AreaFileException("Error reading directory information");
        }
        return this.dirs;
    }

    public String toString() {
        if (this.status <= 0 || this.numDirs <= 0) {
            return new String("No directory information available");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("    Date         Time    Lin  Ele  Bands \n");
        sb.append("  -------       -------  ---  ---  --------\n");
        for (int i = 0; i < this.dirs.size(); ++i) {
            sb.append(((AreaDirectory)this.dirs.get(i)).toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Must supply a path or ADDE request to images");
            System.exit(1);
        }
        AreaDirectoryList adl = new AreaDirectoryList(args[0]);
        System.out.println(adl.toString());
        AreaDirectory[][] ada = adl.getSortedDirs();
        for (int i = 0; i < ada.length; ++i) {
            Date dd = ada[i][0].getNominalTime();
            System.out.print(dd + " ");
            for (int k = 0; k < ada[i].length; ++k) {
                int[] bands = ada[i][k].getBands();
                for (int b = 0; b < bands.length; ++b) {
                    System.out.print(" " + bands[b]);
                }
            }
            System.out.println(" ");
        }
    }

    static {
        try {
            String handlers = System.getProperty("java.protocol.handler.pkgs");
            String newProperty = null;
            if (handlers == null) {
                newProperty = "ucar.mcidas";
            } else if (handlers.indexOf("ucar.mcidas") < 0) {
                newProperty = "ucar.mcidas | " + handlers;
            }
            if (newProperty != null) {
                System.setProperty("java.protocol.handler.pkgs", newProperty);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

