/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.dataset.CoordSystemFactory;
import ucar.nc2.internal.dataset.conv.CSMConvention;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class CF1Convention
extends CSMConvention {
    private static final String CONVENTION_NAME = "CF-1.X";
    private static final String convName = "CF-1.";
    private static final String[] vertical_coords = new String[]{"atmosphere_ln_pressure_coordinate", "atmosphere_sigma_coordinate", "atmosphere_hybrid_sigma_pressure_coordinate", "atmosphere_hybrid_height_coordinate", "atmosphere_sleve_coordinate", "ocean_sigma_coordinate", "ocean_s_coordinate", "ocean_sigma_z_coordinate", "ocean_double_sigma_coordinate", "ocean_s_coordinate_g1", "ocean_s_coordinate_g2"};
    private int cfVersion = 0;
    private boolean avhrr_oiv2;

    public static int getVersion(String hasConvName) {
        int result = CF1Convention.extractVersion(hasConvName);
        if (result >= 0) {
            return result;
        }
        List<String> names = CoordSystemFactory.breakupConventionNames(hasConvName);
        for (String name : names) {
            result = CF1Convention.extractVersion(name);
            if (result < 0) continue;
            return result;
        }
        return -1;
    }

    private static int extractVersion(String hasConvName) {
        if (!hasConvName.startsWith(convName)) {
            return -1;
        }
        String versionS = hasConvName.substring(convName.length());
        try {
            return Integer.parseInt(versionS);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String getZisPositive(String zaxisName, String vertCoordUnits) {
        if (vertCoordUnits == null) {
            return "up";
        }
        if (vertCoordUnits.isEmpty()) {
            return "up";
        }
        if (SimpleUnit.isCompatible("millibar", vertCoordUnits)) {
            return "down";
        }
        if (SimpleUnit.isCompatible("m", vertCoordUnits)) {
            return "up";
        }
        return "up";
    }

    protected CF1Convention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
        String conv = this.rootGroup.getAttributeContainer().findAttributeString("Conventions", null);
        if (conv != null) {
            this.cfVersion = CF1Convention.getVersion(conv);
        }
    }

    @Override
    protected void augmentDataset(CancelTask cancelTask) throws IOException {
        this.augmentGroups(this.rootGroup, cancelTask);
    }

    protected void augmentGroups(Group.Builder gb, CancelTask cancelTask) throws IOException {
        this.augmentGroup(gb, cancelTask);
        for (Group.Builder subGb : gb.gbuilders) {
            this.augmentGroups(subGb, cancelTask);
        }
    }

    protected void augmentGroup(Group.Builder gb, CancelTask cancelTask) throws IOException {
        String src;
        boolean got_grid_mapping = false;
        for (Variable.Builder<?> vb : gb.vbuilders) {
            Optional<Variable.Builder<?>> gridMapOpt;
            String grid_mapping;
            String sname = vb.getAttributeContainer().findAttributeString("standard_name", null);
            if (sname != null) {
                if ((sname = sname.trim()).equalsIgnoreCase("forecast_reference_time")) {
                    vb.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RunTime.toString()));
                    continue;
                }
                if (sname.equalsIgnoreCase("forecast_period")) {
                    vb.addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
                    continue;
                }
                if (sname.equalsIgnoreCase("time")) {
                    vb.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
                }
                if (sname.equalsIgnoreCase("ensemble") || sname.equalsIgnoreCase("realization")) {
                    vb.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
                    continue;
                }
                for (String vertical_coord : vertical_coords) {
                    if (!sname.equalsIgnoreCase(vertical_coord)) continue;
                    vb.addAttribute(new Attribute("_CoordinateTransformType", TransformType.Vertical.toString()));
                    if (vb.getAttributeContainer().findAttribute("_CoordinateAxes") != null) continue;
                    vb.addAttribute(new Attribute("_CoordinateAxes", vb.shortName));
                }
                this.checkTimeVarForCalendar((VariableDS.Builder)vb);
            }
            if ((grid_mapping = vb.getAttributeContainer().findAttributeString("grid_mapping", null)) != null && (gridMapOpt = gb.findVariableLocal(grid_mapping)).isPresent()) {
                Variable.Builder<?> gridMap = gridMapOpt.get();
                gridMap.addAttribute(new Attribute("_CoordinateTransformType", TransformType.Projection.toString()));
                String grid_mapping_name = gridMap.getAttributeContainer().findAttributeString("grid_mapping_name", null);
                if ("latitude_longitude".equals(grid_mapping_name)) {
                    gridMap.addAttribute(new Attribute("_CoordinateAxisTypes", (Object)((Object)AxisType.Lat) + " " + (Object)((Object)AxisType.Lon)));
                } else {
                    gridMap.addAttribute(new Attribute("_CoordinateAxisTypes", (Object)((Object)AxisType.GeoX) + " " + (Object)((Object)AxisType.GeoY)));
                }
                Attribute productionLocation = gb.getAttributeContainer().findAttributeIgnoreCase("production_location");
                Attribute icdVersion = gb.getAttributeContainer().findAttributeIgnoreCase("ICD_version");
                if (productionLocation != null && icdVersion != null) {
                    this.correctGoes16(productionLocation, icdVersion, gridMap);
                }
                got_grid_mapping = true;
            }
            if (this.cfVersion < 8 || vb.getAttributeContainer().findAttribute("geometry") == null) continue;
            String geomValue = vb.getAttributeContainer().findAttributeString("geometry", null);
            gb.findVariableLocal(geomValue).ifPresent(coordsvar -> {
                vb.addAttribute(this.findAttributeIn((Variable.Builder)coordsvar, "geometry_type"));
                vb.addAttribute(this.findAttributeIn((Variable.Builder)coordsvar, "node_coordinates"));
                vb.addAttribute(this.findAttributeIn((Variable.Builder)coordsvar, "part_node_count"));
                this.addOptionalAttributeIn((Variable.Builder)coordsvar, vb, "nodes");
                this.addOptionalAttributeIn((Variable.Builder)coordsvar, vb, "node_count");
                if ("polygon".equalsIgnoreCase(coordsvar.getAttributeContainer().findAttributeString("geometry_type", ""))) {
                    this.addOptionalAttributeIn((Variable.Builder)coordsvar, vb, "interior_ring");
                }
                if (vb.getAttributeContainer().findAttribute("node_coordinates") != null) {
                    String nodeCoords = coordsvar.getAttributeContainer().findAttributeString("node_coordinates", "");
                    String[] coords = nodeCoords.split(" ");
                    StringBuilder cds = new StringBuilder();
                    for (String coord : coords) {
                        gb.findVariableLocal(coord).ifPresent(temp -> {
                            Attribute axis = temp.getAttributeContainer().findAttribute("axis");
                            if (axis != null) {
                                if ("x".equalsIgnoreCase(axis.getStringValue())) {
                                    temp.addAttribute(new Attribute("_CoordinateAxisType", AxisType.SimpleGeometryX.toString()));
                                }
                                if ("y".equalsIgnoreCase(axis.getStringValue())) {
                                    temp.addAttribute(new Attribute("_CoordinateAxisType", AxisType.SimpleGeometryY.toString()));
                                }
                                if ("z".equalsIgnoreCase(axis.getStringValue())) {
                                    temp.addAttribute(new Attribute("_CoordinateAxisType", AxisType.SimpleGeometryZ.toString()));
                                }
                                cds.append(coord);
                                cds.append(" ");
                            }
                        });
                    }
                    ImmutableList<String> dimNames = ImmutableList.copyOf(vb.getDimensionNames());
                    StringBuilder pre = new StringBuilder();
                    for (int i = dimNames.size() - 1; i >= 0; --i) {
                        String dimName = (String)dimNames.get(i);
                        if (!dimName.equals("time")) {
                            gb.findVariableLocal(dimName).ifPresent(coordvar -> coordvar.getAttributeContainer().addAttribute(new Attribute("_CoordinateAxisType", AxisType.SimpleGeometryID.toString())));
                        }
                        pre.append(dimName);
                        pre.append(" ");
                    }
                    vb.addAttribute(new Attribute("_CoordinateAxes", pre + cds.toString().trim()));
                }
            });
        }
        if (!got_grid_mapping) {
            for (Variable.Builder<?> vds : gb.vbuilders) {
                String grid_mapping_name = vds.getAttributeContainer().findAttributeString("grid_mapping_name", null);
                if (grid_mapping_name == null) continue;
                vds.addAttribute(new Attribute("_CoordinateTransformType", TransformType.Projection.toString()));
                if (grid_mapping_name.equals("latitude_longitude")) {
                    vds.addAttribute(new Attribute("_CoordinateAxisTypes", (Object)((Object)AxisType.Lat) + " " + (Object)((Object)AxisType.Lon)));
                    continue;
                }
                vds.addAttribute(new Attribute("_CoordinateAxisTypes", (Object)((Object)AxisType.GeoX) + " " + (Object)((Object)AxisType.GeoY)));
            }
        }
        if ((src = gb.getAttributeContainer().findAttributeString("Source", "")).equals("NOAA/National Climatic Data Center")) {
            String title = gb.getAttributeContainer().findAttributeString("title", "");
            this.avhrr_oiv2 = title.indexOf("OI-V2") > 0;
        }
    }

    Attribute findAttributeIn(Variable.Builder coordsvar, String attName) {
        return new Attribute(attName, coordsvar.getAttributeContainer().findAttributeString(attName, ""));
    }

    void addOptionalAttributeIn(Variable.Builder src, Variable.Builder dest, String attName) {
        Attribute att = src.getAttributeContainer().findAttribute(attName);
        if (att != null) {
            dest.addAttribute(att);
        }
    }

    private void correctGoes16(Attribute productionLocation, Attribute icdVersion, Variable.Builder<?> gridMappingVar) {
        String prodLoc = productionLocation.getStringValue();
        String icdVer = icdVersion.getStringValue();
        if (prodLoc != null && icdVer != null) {
            prodLoc = prodLoc.toLowerCase().trim();
            icdVer = icdVer.toLowerCase().trim();
            boolean mightNeedCorrected = prodLoc.contains("wcdas");
            mightNeedCorrected = mightNeedCorrected && icdVer.contains("ground segment");
            boolean bl = mightNeedCorrected = mightNeedCorrected && icdVer.contains("awips");
            if (mightNeedCorrected) {
                ImmutableMap<String, String> possibleCorrections = ImmutableMap.of("semi_minor", "semi_minor_axis", "semi_major", "semi_major_axis");
                possibleCorrections.forEach((incorrect, correct) -> {
                    Array vals;
                    Attribute attr = gridMappingVar.getAttributeContainer().findAttributeIgnoreCase((String)incorrect);
                    if (attr != null && (vals = attr.getValues()) != null) {
                        gridMappingVar.getAttributeContainer().replace(attr, (String)correct);
                        log.debug("Renamed {} attribute {} to {}", gridMappingVar, incorrect, correct);
                    }
                });
            }
        }
    }

    @Override
    public AxisType getAxisType(VariableDS.Builder vb) {
        String axis;
        AxisType at;
        String sname = vb.getAttributeContainer().findAttributeString("standard_name", null);
        if (sname != null) {
            sname = sname.trim();
            for (String vertical_coord : vertical_coords) {
                if (!sname.equalsIgnoreCase(vertical_coord)) continue;
                return AxisType.GeoZ;
            }
        }
        if ((at = super.getAxisType(vb)) != null) {
            return at;
        }
        if (sname != null) {
            if (sname.equalsIgnoreCase("realization")) {
                return AxisType.Ensemble;
            }
            if (sname.equalsIgnoreCase("latitude")) {
                return AxisType.Lat;
            }
            if (sname.equalsIgnoreCase("longitude")) {
                return AxisType.Lon;
            }
            if (sname.equalsIgnoreCase("projection_x_coordinate") || sname.equalsIgnoreCase("grid_longitude") || sname.equalsIgnoreCase("rotated_longitude")) {
                return AxisType.GeoX;
            }
            if (sname.equalsIgnoreCase("projection_y_coordinate") || sname.equalsIgnoreCase("grid_latitude") || sname.equalsIgnoreCase("rotated_latitude")) {
                return AxisType.GeoY;
            }
            if (sname.equalsIgnoreCase("forecast_reference_time")) {
                return AxisType.RunTime;
            }
            if (sname.equalsIgnoreCase("forecast_period")) {
                return AxisType.TimeOffset;
            }
        }
        if ((axis = vb.getAttributeContainer().findAttributeString("axis", null)) != null) {
            axis = axis.trim();
            String unit = vb.getUnits();
            if (axis.equalsIgnoreCase("X")) {
                if (SimpleUnit.isCompatible("m", unit)) {
                    return AxisType.GeoX;
                }
            } else if (axis.equalsIgnoreCase("Y")) {
                if (SimpleUnit.isCompatible("m", unit)) {
                    return AxisType.GeoY;
                }
            } else if (axis.equalsIgnoreCase("Z")) {
                if (unit == null) {
                    return AxisType.GeoZ;
                }
                if (SimpleUnit.isCompatible("m", unit)) {
                    return AxisType.Height;
                }
                if (SimpleUnit.isCompatible("mbar", unit)) {
                    return AxisType.Pressure;
                }
                return AxisType.GeoZ;
            }
        }
        if (this.avhrr_oiv2 && vb.shortName.equals("zlev")) {
            return AxisType.Height;
        }
        try {
            String units = vb.getUnits();
            CalendarDateUnit cd2 = CalendarDateUnit.of(null, units);
            return AxisType.Time;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return CF1Convention.CONVENTION_NAME;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new CF1Convention(datasetBuilder);
        }
    }
}

