/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.nc2.wmo.Util;
import ucar.unidata.util.StringUtil2;

public class WmoXmlReader {
    private static Logger log = LoggerFactory.getLogger(WmoXmlReader.class);

    static void readWmoXmlTableB(InputStream ios, TableB b) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(ios);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element root = doc.getRootElement();
        String[] elems = WmoXmlReader.elementsUsedFromTableB(root);
        ArrayList<Element> unrecognizedSequenceTermElements = new ArrayList<Element>();
        List<Element> featList = root.getChildren();
        for (Element elem : featList) {
            Element ce = null;
            for (int nameTest = 1; nameTest < elems.length && (ce = elem.getChild(elems[nameTest])) == null; ++nameTest) {
            }
            if (ce == null) {
                unrecognizedSequenceTermElements.add(elem);
                continue;
            }
            String name = Util.cleanName(ce.getTextNormalize());
            String units = WmoXmlReader.cleanUnit(elem.getChildTextNormalize("BUFR_Unit"));
            int x = 0;
            int y = 0;
            int scale = 0;
            int reference = 0;
            int width = 0;
            String fxy = null;
            String s2 = null;
            try {
                fxy = elem.getChildTextNormalize("FXY");
                int xy = Integer.parseInt(WmoXmlReader.cleanNumber(fxy));
                x = xy / 1000;
                y = xy % 1000;
            }
            catch (NumberFormatException e) {
                log.warn(" key {} name '{}' fails parsing", (Object)fxy, (Object)name);
            }
            try {
                s2 = elem.getChildTextNormalize("BUFR_Scale");
                scale = Integer.parseInt(WmoXmlReader.cleanNumber(s2));
            }
            catch (NumberFormatException e) {
                log.warn(" key {} name '{}' has bad scale='{}'", fxy, name, s2);
            }
            try {
                s2 = elem.getChildTextNormalize("BUFR_ReferenceValue");
                reference = Integer.parseInt(WmoXmlReader.cleanNumber(s2));
            }
            catch (NumberFormatException e) {
                log.warn(" key {} name '{}' has bad reference='{}'", fxy, name, s2);
            }
            try {
                s2 = elem.getChildTextNormalize("BUFR_DataWidth_Bits");
                width = Integer.parseInt(WmoXmlReader.cleanNumber(s2));
            }
            catch (NumberFormatException e) {
                log.warn(" key {} name '{}' has bad width='{}'", fxy, name, s2);
            }
            b.addDescriptor((short)x, (short)y, scale, reference, width, name, units, null);
        }
        if (log.isDebugEnabled()) {
            WmoXmlReader.logUnrecognizedElements(unrecognizedSequenceTermElements, "B", b.getLocation());
        }
        ios.close();
    }

    static String cleanNumber(String s2) {
        return StringUtil2.remove(s2, 32);
    }

    public static String cleanUnit(String unit) {
        String result = StringUtil2.remove(unit, 176);
        return StringUtil2.replace(result, '\ufffd', "2");
    }

    static String[] elementsUsedFromTableD(Element root) {
        return WmoXmlReader.elementsUsedFromTable(root, "D");
    }

    static String[] elementsUsedFromTableB(Element root) {
        return WmoXmlReader.elementsUsedFromTable(root, "B");
    }

    static String[] elementsUsedFromTable(Element root, String tableType) {
        String[] elems = null;
        for (Version v : Version.values()) {
            boolean match = root.getAttributes().stream().anyMatch(attr -> attr.getValue().contains(v.toString()));
            if (!match) continue;
            elems = tableType.equals("B") ? v.getElemNamesB() : v.getElemNamesD();
            break;
        }
        if (elems == null) {
            for (Version v : Version.values()) {
                elems = tableType.equals("B") ? v.getElemNamesB() : v.getElemNamesD();
                List<Element> featList = null;
                if (elems != null && elems.length > 0) {
                    featList = root.getChildren(elems[0]);
                }
                if (featList != null && !featList.isEmpty()) break;
            }
        }
        return elems;
    }

    static void logUnrecognizedElements(List<Element> unrecognizedSequenceTermElements, String tableType, String location) {
        if (log.isDebugEnabled() && unrecognizedSequenceTermElements.size() > 0) {
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append(String.format("%d Unprocessed sequences in WMO table %s %s", unrecognizedSequenceTermElements.size(), tableType, location));
            if (tableType.equals("D")) {
                String tableDChecker = "bufr/src/test/java/ucar/nc2/iosp/bufr/tables/WmoTableDVariations.java";
                msgBuilder.append(String.format("This might be ok, but to know for sure, consider running %s", tableDChecker));
            }
            log.debug(msgBuilder.toString());
        }
    }

    static void readWmoXmlTableD(InputStream ios, TableD tableD) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(ios);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        int currSeqno = -1;
        TableD.Descriptor currDesc = null;
        Element root = doc.getRootElement();
        String[] elems = WmoXmlReader.elementsUsedFromTableD(root);
        ArrayList<Element> unrecognizedSequenceTermElements = new ArrayList<Element>();
        List<Element> featList = root.getChildren();
        for (Element elem : featList) {
            Element ce = null;
            for (int nameTest = 1; nameTest < elems.length && (ce = elem.getChild(elems[nameTest])) == null; ++nameTest) {
            }
            if (ce == null) {
                unrecognizedSequenceTermElements.add(elem);
                continue;
            }
            String seqs = elem.getChildTextNormalize("FXY1");
            int seq = Integer.parseInt(seqs);
            if (currSeqno != seq) {
                int y = seq % 1000;
                int w = seq / 1000;
                int x = w % 100;
                String seqName = Util.cleanName(ce.getTextNormalize());
                currDesc = tableD.addDescriptor((short)x, (short)y, seqName, new ArrayList<Short>());
                currSeqno = seq;
            }
            String fnos = elem.getChildTextNormalize("FXY2");
            int fno = Integer.parseInt(fnos);
            int y = fno % 1000;
            int w = fno / 1000;
            int x = w % 100;
            int f = w / 100;
            int fxy = (f << 14) + (x << 8) + y;
            currDesc.addFeature((short)fxy);
        }
        if (log.isDebugEnabled()) {
            WmoXmlReader.logUnrecognizedElements(unrecognizedSequenceTermElements, "D", tableD.getLocation());
        }
        ios.close();
    }

    public static enum Version {
        BUFR_14_1_0,
        BUFR_14_2_0,
        BUFR_15_1_1,
        BUFR_16_0_0,
        BUFR_WMO;


        String[] getElemNamesB() {
            if (this == BUFR_14_1_0) {
                return new String[]{"BC_TableB_BUFR14_1_0_CREX_6_1_0", "ElementName_E"};
            }
            if (this == BUFR_14_2_0) {
                return new String[]{"Exporting_BCTableB_E", "ElementName"};
            }
            if (this == BUFR_15_1_1) {
                return new String[]{"Exp_JointTableB_E", "ElementName_E"};
            }
            if (this == BUFR_16_0_0) {
                return new String[]{"Exp_BUFRCREXTableB_E", "ElementName_E"};
            }
            if (this == BUFR_WMO) {
                return new String[]{null, "ElementName_en"};
            }
            return null;
        }

        String[] getElemNamesD() {
            if (this == BUFR_14_1_0) {
                return new String[]{"B_TableD_BUFR14_1_0_CREX_6_1_0", "ElementName1_E"};
            }
            if (this == BUFR_14_2_0) {
                return new String[]{"Exporting_BUFRTableD_E", "ElementName1"};
            }
            if (this == BUFR_15_1_1) {
                return new String[]{"Exp_BUFRTableD_E", "ElementName_E", "ExistingElementName_E"};
            }
            if (this == BUFR_16_0_0) {
                return new String[]{"Exp_BUFRTableD_E", "ElementName_E", "ExistingElementName_E"};
            }
            if (this == BUFR_WMO) {
                return new String[]{null, "ElementName_en"};
            }
            return null;
        }
    }
}

