/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import ucar.ma2.DataType;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.dataset.CoordSystemFactory;
import ucar.nc2.util.CancelTask;

public class DatasetEnhancer {
    private final NetcdfFile ncfile;
    private final NetcdfDataset.Builder ds;
    private final Set<NetcdfDataset.Enhance> wantEnhance;
    private final CancelTask cancelTask;

    public static boolean enhanceNeeded(Set<NetcdfDataset.Enhance> want, Set<NetcdfDataset.Enhance> have) {
        if (want == null) {
            return false;
        }
        if (have == null && !want.isEmpty()) {
            return true;
        }
        for (NetcdfDataset.Enhance mode : want) {
            if (have.contains((Object)mode)) continue;
            return true;
        }
        return false;
    }

    public DatasetEnhancer(NetcdfFile ncfile, NetcdfDataset.Builder ds, Set<NetcdfDataset.Enhance> wantEnhance, CancelTask cancelTask) {
        this.ncfile = ncfile;
        this.ds = ds;
        this.wantEnhance = wantEnhance == null ? EnumSet.noneOf(NetcdfDataset.Enhance.class) : wantEnhance;
        this.cancelTask = cancelTask;
    }

    public NetcdfDataset enhance() throws IOException {
        CoordSystemBuilder coordSysBuilder = null;
        if (this.wantEnhance.contains((Object)NetcdfDataset.Enhance.CoordSystems) && !this.ds.enhanceMode.contains((Object)NetcdfDataset.Enhance.CoordSystems)) {
            Optional<CoordSystemBuilder> hasNewBuilder = CoordSystemFactory.factory(this.ds, this.cancelTask);
            if (!hasNewBuilder.isPresent()) {
                return this.useOldBuilder();
            }
            coordSysBuilder = hasNewBuilder.get();
            coordSysBuilder.augmentDataset(this.cancelTask);
            this.ds.setConventionUsed(coordSysBuilder.getConventionUsed());
        }
        this.enhanceGroup(this.ds.rootGroup);
        if (coordSysBuilder != null) {
            if (this.wantEnhance.contains((Object)NetcdfDataset.Enhance.IncompleteCoordSystems)) {
                this.ds.enhanceMode.add(NetcdfDataset.Enhance.IncompleteCoordSystems);
                coordSysBuilder.buildCoordinateSystems();
                this.ds.enhanceMode.remove((Object)NetcdfDataset.Enhance.IncompleteCoordSystems);
            } else {
                coordSysBuilder.buildCoordinateSystems();
            }
        }
        this.ds.enhanceMode.addAll(this.wantEnhance);
        return this.ds.build();
    }

    private void enhanceGroup(Group.Builder group) {
        for (Variable.Builder<?> vb : group.vbuilders) {
            if (vb instanceof StructureDS.Builder) {
                this.enhanceStructure((StructureDS.Builder)vb);
                continue;
            }
            if (vb instanceof VariableDS.Builder) {
                this.enhanceVariable((VariableDS.Builder)vb);
                continue;
            }
            throw new IllegalStateException("Not a VariableDS " + vb.shortName);
        }
        for (Group.Builder gb : group.gbuilders) {
            this.enhanceGroup(gb);
        }
    }

    private void enhanceStructure(StructureDS.Builder<?> sdb) {
        for (Variable.Builder vb : sdb.vbuilders) {
            if (vb instanceof StructureDS.Builder) {
                this.enhanceStructure((StructureDS.Builder)vb);
                continue;
            }
            if (vb instanceof VariableDS.Builder) {
                this.enhanceVariable((VariableDS.Builder)vb);
                continue;
            }
            throw new IllegalStateException("Not a VariableDS " + vb.shortName);
        }
    }

    private void enhanceVariable(VariableDS.Builder vb) {
        EnumSet<NetcdfDataset.Enhance> varEnhance = EnumSet.copyOf(this.wantEnhance);
        if (vb.orgVar instanceof VariableDS) {
            for (NetcdfDataset.Enhance orgVarEnhancement : ((VariableDS)vb.orgVar).getEnhanceMode()) {
                varEnhance.remove((Object)orgVarEnhancement);
            }
        }
        if (varEnhance.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && vb.dataType.isEnum()) {
            vb.setDataType(DataType.STRING);
            return;
        }
        vb.addEnhanceMode(varEnhance);
    }

    private NetcdfDataset useOldBuilder() throws IOException {
        return NetcdfDataset.wrap(this.ncfile, this.wantEnhance);
    }
}

