/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerAdapter;
import thredds.crawlabledataset.S3URI;
import thredds.crawlabledataset.ThreddsS3ClientImpl;

public class EhCachingThreddsS3Client {
    private static final String EHCACHE_S3_OBJECT_KEY = "S3Objects";
    private static final String EHCACHE_S3_OBJECT_METADATA_KEY = "S3ObjectMetadata";
    private static final String EHCACHE_S3_LISTING_KEY = "S3Listing";
    private static final int EHCACHE_MAX_OBJECTS = 1000;
    private static final int EHCACHE_TTL = 60;
    private static final int EHCACHE_TTI = 60;
    private final ThreddsS3ClientImpl threddsS3Client;

    public EhCachingThreddsS3Client(ThreddsS3ClientImpl threddsS3Client) {
        this.threddsS3Client = threddsS3Client;
    }

    public Cache getS3ObjectMetadataCache() {
        return this.getS3Cache(EHCACHE_S3_OBJECT_METADATA_KEY);
    }

    public Cache getS3ListingCache() {
        return this.getS3Cache(EHCACHE_S3_LISTING_KEY);
    }

    public Cache getS3ObjectCache() {
        return this.getS3Cache(EHCACHE_S3_OBJECT_KEY, (CacheEventListener)new S3CacheEventListener());
    }

    private Cache getS3Cache(String cacheName) {
        return this.getS3Cache(cacheName, null);
    }

    private Cache getS3Cache(String cacheName, CacheEventListener eventListener) {
        CacheManager cacheManager = CacheManager.create();
        if (!cacheManager.cacheExists(cacheName)) {
            Cache newCache = new Cache(cacheName, 1000, false, false, 60L, 60L);
            if (null != eventListener) {
                newCache.getCacheEventNotificationService().registerListener(eventListener);
            }
            cacheManager.addCache(newCache);
        }
        return cacheManager.getCache(cacheName);
    }

    private void deleteFileElement(Element element) {
    }

    public ObjectMetadata getObjectMetadata(S3URI s3uri) {
        Element element = this.getS3ObjectMetadataCache().get((Object)s3uri);
        if (element != null) {
            return (ObjectMetadata)element.getObjectValue();
        }
        ObjectMetadata metadata = this.threddsS3Client.getObjectMetadata(s3uri);
        this.getS3ObjectMetadataCache().put(new Element((Object)s3uri, (Object)metadata));
        return metadata;
    }

    public ObjectListing listObjects(S3URI s3uri) {
        Element element = this.getS3ListingCache().get((Object)s3uri);
        if (element != null) {
            return (ObjectListing)element.getObjectValue();
        }
        ObjectListing objectListing = this.threddsS3Client.listObjects(s3uri);
        this.getS3ListingCache().put(new Element((Object)s3uri, (Object)objectListing));
        return objectListing;
    }

    public ObjectMetadata saveObjectToFile(S3URI s3uri, File file) throws IOException {
        File cachedFile;
        Element element = this.getS3ObjectCache().get((Object)s3uri);
        if (element != null && !file.equals(cachedFile = (File)element.getObjectValue())) {
            Files.copy(cachedFile, file);
            this.getS3ObjectCache().put(new Element((Object)s3uri, (Object)file));
        }
        return null;
    }

    private class S3CacheEventListener
    extends CacheEventListenerAdapter {
        private S3CacheEventListener() {
        }

        public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
            EhCachingThreddsS3Client.this.deleteFileElement(element);
        }

        public void notifyElementExpired(Ehcache cache, Element element) {
            EhCachingThreddsS3Client.this.deleteFileElement(element);
        }

        public void notifyElementEvicted(Ehcache cache, Element element) {
            EhCachingThreddsS3Client.this.deleteFileElement(element);
        }
    }
}

