/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.jni.netcdf;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.ffi.netcdf.NetcdfClibrary;
import ucar.nc2.internal.util.EscapeStrings;
import ucar.nc2.internal.util.URLnaming;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.NetcdfFileFormat;
import ucar.nc2.jni.netcdf.Nc4prototypes;
import ucar.nc2.jni.netcdf.SizeT;
import ucar.nc2.jni.netcdf.SizeTByReference;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Nc4reader
extends AbstractIOServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(Nc4reader.class);
    private static final boolean debugCompoundAtt = false;
    private static final boolean debugUserTypes = false;
    private static final boolean transcodeStrings = Charset.defaultCharset() != StandardCharsets.UTF_8;
    Nc4prototypes nc4;
    NetcdfFileFormat version;
    int ncid = -1;
    boolean markReserved;
    boolean isClosed;
    private int format;
    final Map<Integer, UserType> userTypes = new HashMap<Integer, UserType>();
    final Map<Group.Builder, Integer> groupBuilderHash = new HashMap<Group.Builder, Integer>();
    Group.Builder rootGroup;

    public Nc4reader() {
        this(NetcdfFileFormat.NETCDF4);
    }

    Nc4reader(NetcdfFileFormat version) {
        this.version = version;
    }

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        NetcdfFileFormat format = NetcdfFileFormat.findNetcdfFormatType((RandomAccessFile)raf);
        boolean valid = false;
        switch (format) {
            case NETCDF4: 
            case NETCDF4_CLASSIC: 
            case NETCDF3_64BIT_DATA: {
                valid = true;
                break;
            }
        }
        if (valid) {
            if (NetcdfClibrary.isLibraryPresent()) {
                return true;
            }
            log.debug("File is valid but the NetCDF-4 native library isn't installed: {}", (Object)raf.getLocation());
        }
        return false;
    }

    public String getFileTypeDescription() {
        return "Netcdf/JNI: " + this.version;
    }

    public String getFileTypeId() {
        return this.version.isNetdf4format() ? DataFormatType.NETCDF4.getDescription() : DataFormatType.HDF5.getDescription();
    }

    public String getFileTypeVersion() {
        return this.ncfile.getRootGroup().findAttributeString("_NCProperties", "N/A");
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.ncid < 0) {
            return;
        }
        int ret = this.nc4.nc_close(this.ncid);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        this.isClosed = true;
    }

    public Object sendIospMessage(Object message) {
        if (message.equals("NetcdfFileFormat")) {
            return this.version;
        }
        return super.sendIospMessage(message);
    }

    public void build(RandomAccessFile raf, Group.Builder rootGroup, CancelTask cancelTask) throws IOException {
        super.open(raf, rootGroup.getNcfile(), cancelTask);
        this.rootGroup = rootGroup;
        if (!NetcdfClibrary.isLibraryPresent()) {
            throw new UnsupportedOperationException("Couldn't load NetCDF C library (see log for details).");
        }
        this.nc4 = NetcdfClibrary.getForeignFunctionInterface();
        if (raf != null) {
            raf.close();
        }
        String location = URLnaming.canonicalizeUriString((String)this.location);
        log.debug("open {}", (Object)location);
        IntByReference ncidp = new IntByReference();
        int ret = this.nc4.nc_open(location, 0, ncidp);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        this.isClosed = false;
        this.ncid = ncidp.getValue();
        IntByReference formatp = new IntByReference();
        ret = this.nc4.nc_inq_format(this.ncid, formatp);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        this.format = formatp.getValue();
        log.debug("open {} id={} format={}", new Object[]{this.location, this.ncid, this.format});
        this.makeGroup(new Group4(this.ncid, rootGroup, null));
    }

    private void makeGroup(Group4 g4) throws IOException {
        this.groupBuilderHash.put(g4.g, g4.grpid);
        this.makeDimensions(g4);
        this.makeUserTypes(g4.grpid, g4.g);
        IntByReference ngattsp = new IntByReference();
        int ret = this.nc4.nc_inq_natts(g4.grpid, ngattsp);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        List<Attribute> gatts = this.makeAttributes(g4.grpid, -1, ngattsp.getValue(), null);
        for (Attribute att : gatts) {
            g4.g.addAttribute(att);
            log.debug(" add Global Attribute {}", (Object)att);
        }
        this.makeVariables(g4);
        if (this.format == 3) {
            IntByReference numgrps = new IntByReference();
            ret = this.nc4.nc_inq_grps(g4.grpid, numgrps, null);
            if (ret != 0) {
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            int[] group_ids = new int[numgrps.getValue()];
            ret = this.nc4.nc_inq_grps(g4.grpid, numgrps, group_ids);
            if (ret != 0) {
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            for (int group_id : group_ids) {
                byte[] name = new byte[257];
                ret = this.nc4.nc_inq_grpname(group_id, name);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                Group.Builder child = Group.builder().setName(this.makeString(name));
                g4.g.addGroup(child);
                this.makeGroup(new Group4(group_id, child, g4));
            }
        }
    }

    private void makeDimensions(Group4 g4) throws IOException {
        IntByReference numDimsInGoup_p = new IntByReference();
        int ret = this.nc4.nc_inq_ndims(g4.grpid, numDimsInGoup_p);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        IntByReference numDimidsInGroup_p = new IntByReference();
        int[] dimIdsInGroup = new int[numDimsInGoup_p.getValue()];
        ret = this.nc4.nc_inq_dimids(g4.grpid, numDimidsInGroup_p, dimIdsInGroup, 0);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        assert (numDimsInGoup_p.getValue() == numDimidsInGroup_p.getValue()) : String.format("Number of dimensions in group (%s) differed from number of dimension IDs in group (%s).", numDimsInGoup_p.getValue(), numDimidsInGroup_p.getValue());
        IntByReference numUnlimitedDimsInGroup_p = new IntByReference();
        ret = this.nc4.nc_inq_unlimdims(g4.grpid, numUnlimitedDimsInGroup_p, null);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        int[] unlimitedDimIdsInGroup = new int[numUnlimitedDimsInGroup_p.getValue()];
        ret = this.nc4.nc_inq_unlimdims(g4.grpid, numUnlimitedDimsInGroup_p, unlimitedDimIdsInGroup);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        Arrays.sort(unlimitedDimIdsInGroup);
        for (int dimId : dimIdsInGroup) {
            byte[] dimNameBytes = new byte[257];
            SizeTByReference dimLength_p = new SizeTByReference();
            ret = this.nc4.nc_inq_dim(g4.grpid, dimId, dimNameBytes, dimLength_p);
            if (ret != 0) {
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            String dimName = this.makeString(dimNameBytes);
            boolean isUnlimited = Arrays.binarySearch(unlimitedDimIdsInGroup, dimId) >= 0;
            Dimension dimension = new Dimension(dimName, dimLength_p.getValue().intValue(), true, isUnlimited, false);
            g4.g.addDimension(dimension);
            log.debug("add Dimension {} ({})", (Object)dimension, (Object)dimId);
        }
    }

    private String[] transcodeString(String[] systemStrings) {
        return (String[])Arrays.stream(systemStrings).map(systemString -> {
            byte[] byteArray = systemString.getBytes(Charset.defaultCharset());
            return new String(byteArray, StandardCharsets.UTF_8);
        }).toArray(String[]::new);
    }

    String makeString(byte[] b) {
        int count;
        for (count = 0; count < b.length && b[count] != 0; ++count) {
        }
        if (count < b.length / 2) {
            byte[] bb = new byte[count];
            System.arraycopy(b, 0, bb, 0, count);
            b = bb;
        }
        return new String(b, 0, count, StandardCharsets.UTF_8);
    }

    private String makeAttString(byte[] b) {
        int count;
        for (count = 0; count < b.length && b[count] != 0; ++count) {
        }
        return new String(b, 0, count, StandardCharsets.UTF_8);
    }

    private List<Attribute> makeAttributes(int grpid, int varid, int natts, Variable.Builder<?> v) throws IOException {
        ArrayList<Attribute> result = new ArrayList<Attribute>(natts);
        block28: for (int attnum = 0; attnum < natts; ++attnum) {
            IntByReference xtypep;
            byte[] name = new byte[257];
            int ret = this.nc4.nc_inq_attname(grpid, varid, attnum, name);
            if (ret != 0) {
                throw new IOException(this.nc4.nc_strerror(ret) + " varid=" + varid + " attnum=" + attnum);
            }
            String attname = this.makeString(name);
            ret = this.nc4.nc_inq_atttype(grpid, varid, attname, xtypep = new IntByReference());
            if (ret != 0) {
                throw new IOException(this.nc4.nc_strerror(ret) + " varid=" + varid + "attnum=" + attnum);
            }
            int type = xtypep.getValue();
            SizeTByReference lenp = new SizeTByReference();
            ret = this.nc4.nc_inq_attlen(grpid, varid, attname, lenp);
            if (ret != 0) {
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            int len = lenp.getValue().intValue();
            if (len == 0) {
                Attribute att;
                switch (type) {
                    case 1: {
                        att = Attribute.emptyValued((String)attname, (DataType)DataType.BYTE);
                        break;
                    }
                    case 7: {
                        att = Attribute.emptyValued((String)attname, (DataType)DataType.UBYTE);
                        break;
                    }
                    case 2: {
                        if (this.format == 4 || this.format == 3) {
                            att = Attribute.emptyValued((String)attname, (DataType)DataType.STRING);
                            break;
                        }
                        att = new Attribute(attname, "");
                        break;
                    }
                    case 6: {
                        att = Attribute.emptyValued((String)attname, (DataType)DataType.DOUBLE);
                        break;
                    }
                    case 5: {
                        att = Attribute.emptyValued((String)attname, (DataType)DataType.FLOAT);
                        break;
                    }
                    case 4: {
                        att = Attribute.emptyValued((String)attname, (DataType)DataType.INT);
                        break;
                    }
                    case 9: {
                        att = Attribute.emptyValued((String)attname, (DataType)DataType.UINT);
                        break;
                    }
                    case 11: {
                        att = Attribute.emptyValued((String)attname, (DataType)DataType.ULONG);
                        break;
                    }
                    case 10: {
                        att = Attribute.emptyValued((String)attname, (DataType)DataType.LONG);
                        break;
                    }
                    case 8: {
                        att = Attribute.emptyValued((String)attname, (DataType)DataType.USHORT);
                        break;
                    }
                    case 3: {
                        att = Attribute.emptyValued((String)attname, (DataType)DataType.SHORT);
                        break;
                    }
                    case 12: {
                        att = Attribute.emptyValued((String)attname, (DataType)DataType.STRING);
                        break;
                    }
                    default: {
                        log.warn("Unsupported attribute data type == " + type);
                        continue block28;
                    }
                }
                result.add(att);
                continue;
            }
            Array values = null;
            switch (type) {
                case 7: {
                    byte[] valbu = new byte[len];
                    ret = this.nc4.nc_get_att_uchar(grpid, varid, attname, valbu);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    values = Array.factory((DataType)DataType.UBYTE, (int[])new int[]{len}, (Object)valbu);
                    break;
                }
                case 1: {
                    byte[] valb = new byte[len];
                    ret = this.nc4.nc_get_att_schar(grpid, varid, attname, valb);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    values = Array.factory((DataType)DataType.BYTE, (int[])new int[]{len}, (Object)valb);
                    break;
                }
                case 2: {
                    byte[] text = new byte[len];
                    ret = this.nc4.nc_get_att_text(grpid, varid, attname, text);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    Attribute att = new Attribute(attname, this.makeAttString(text));
                    result.add(att);
                    break;
                }
                case 6: {
                    double[] vald = new double[len];
                    ret = this.nc4.nc_get_att_double(grpid, varid, attname, vald);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    values = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{len}, (Object)vald);
                    break;
                }
                case 5: {
                    float[] valf = new float[len];
                    ret = this.nc4.nc_get_att_float(grpid, varid, attname, valf);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    values = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{len}, (Object)valf);
                    break;
                }
                case 9: {
                    int[] valiu = new int[len];
                    ret = this.nc4.nc_get_att_uint(grpid, varid, attname, valiu);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    values = Array.factory((DataType)DataType.UINT, (int[])new int[]{len}, (Object)valiu);
                    break;
                }
                case 4: {
                    int[] vali = new int[len];
                    ret = this.nc4.nc_get_att_int(grpid, varid, attname, vali);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    values = Array.factory((DataType)DataType.INT, (int[])new int[]{len}, (Object)vali);
                    break;
                }
                case 11: {
                    long[] vallu = new long[len];
                    ret = this.nc4.nc_get_att_ulonglong(grpid, varid, attname, vallu);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    values = Array.factory((DataType)DataType.ULONG, (int[])new int[]{len}, (Object)vallu);
                    break;
                }
                case 10: {
                    long[] vall = new long[len];
                    ret = this.nc4.nc_get_att_longlong(grpid, varid, attname, vall);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    values = Array.factory((DataType)DataType.LONG, (int[])new int[]{len}, (Object)vall);
                    break;
                }
                case 8: {
                    short[] valsu = new short[len];
                    ret = this.nc4.nc_get_att_ushort(grpid, varid, attname, valsu);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    values = Array.factory((DataType)DataType.USHORT, (int[])new int[]{len}, (Object)valsu);
                    break;
                }
                case 3: {
                    short[] vals = new short[len];
                    ret = this.nc4.nc_get_att_short(grpid, varid, attname, vals);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    values = Array.factory((DataType)DataType.SHORT, (int[])new int[]{len}, (Object)vals);
                    break;
                }
                case 12: {
                    String[] valss = new String[len];
                    ret = this.nc4.nc_get_att_string(grpid, varid, attname, valss);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                    }
                    if (transcodeStrings) {
                        valss = this.transcodeString(valss);
                    }
                    values = Array.factory((DataType)DataType.STRING, (int[])new int[]{len}, (Object)valss);
                    break;
                }
                default: {
                    UserType userType = this.userTypes.get(type);
                    if (userType == null) {
                        log.warn("Unsupported attribute data type == " + type);
                        continue block28;
                    }
                    if (userType.typeClass == 15) {
                        result.add(this.readEnumAttValues(grpid, varid, attname, len, userType));
                        continue block28;
                    }
                    if (userType.typeClass == 14) {
                        result.add(this.readOpaqueAttValues(grpid, varid, attname, len, userType));
                        continue block28;
                    }
                    if (userType.typeClass == 13) {
                        values = this.readVlenAttValues(grpid, varid, attname, len, userType);
                        break;
                    }
                    if (userType.typeClass == 16) {
                        this.readCompoundAttValues(grpid, varid, attname, len, userType, result, v);
                        continue block28;
                    }
                    log.warn("Unsupported attribute data type == " + userType);
                    continue block28;
                }
            }
            if (values == null) continue;
            Attribute att = Attribute.fromArray((String)attname, (Array)values);
            result.add(att);
        }
        return result;
    }

    private Array readVlenAttValues(int grpid, int varid, String attname, int len, UserType userType) throws IOException {
        Nc4prototypes.Vlen_t[] vlen = new Nc4prototypes.Vlen_t[len];
        int ret = this.nc4.nc_get_att(grpid, varid, attname, vlen);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        int count = 0;
        for (int i = 0; i < len; ++i) {
            count += vlen[i].len;
        }
        switch (userType.baseTypeid) {
            case 4: {
                Array intArray = Array.factory((DataType)DataType.INT, (int[])new int[]{count});
                IndexIterator iter = intArray.getIndexIterator();
                for (int i = 0; i < len; ++i) {
                    int[] ba;
                    for (int aBa : ba = vlen[i].p.getIntArray(0L, vlen[i].len)) {
                        iter.setIntNext(aBa);
                    }
                }
                return intArray;
            }
            case 5: {
                Array fArray = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{count});
                IndexIterator iter = fArray.getIndexIterator();
                for (int i = 0; i < len; ++i) {
                    float[] ba;
                    for (float aBa : ba = vlen[i].p.getFloatArray(0L, vlen[i].len)) {
                        iter.setFloatNext(aBa);
                    }
                }
                return fArray;
            }
        }
        return null;
    }

    private Attribute readEnumAttValues(int grpid, int varid, String attname, int len, UserType userType) throws IOException {
        DataType dtype = this.convertDataType((int)userType.baseTypeid).dt;
        int elemSize = dtype.getSize();
        byte[] bbuff = new byte[len * elemSize];
        int ret = this.nc4.nc_get_att(grpid, varid, attname, bbuff);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        ByteBuffer bb = ByteBuffer.wrap(bbuff);
        String[] econsts = new String[len];
        EnumTypedef en = userType.e;
        for (int i = 0; i < len; ++i) {
            long lval = 0L;
            switch (en.getBaseType()) {
                case ENUM1: {
                    lval = bb.get(i);
                    break;
                }
                case ENUM2: {
                    lval = bb.getShort(i);
                    break;
                }
                case ENUM4: {
                    lval = bb.getInt(i);
                }
            }
            int ival = (int)lval;
            String name = en.lookupEnumString(ival);
            if (name == null) {
                name = "Unknown enum value=" + ival;
            }
            econsts[i] = name;
        }
        Array data = Array.factory((DataType)DataType.STRING, (int[])new int[]{len}, (Object)econsts);
        return Attribute.builder((String)attname).setValues(data).setEnumType(userType.e).build();
    }

    private Array convertByteBuffer(ByteBuffer bb, int baseType, int[] shape) {
        switch (baseType) {
            case 1: {
                return Array.factory((DataType)DataType.BYTE, (int[])shape, (Object)bb.array());
            }
            case 7: {
                return Array.factory((DataType)DataType.UBYTE, (int[])shape, (Object)bb.array());
            }
            case 3: {
                return Array.factory((DataType)DataType.SHORT, (int[])shape, (Object)bb.asShortBuffer().array());
            }
            case 8: {
                return Array.factory((DataType)DataType.USHORT, (int[])shape, (Object)bb.asShortBuffer().array());
            }
            case 4: {
                return Array.factory((DataType)DataType.INT, (int[])shape, (Object)bb.asIntBuffer().array());
            }
            case 9: {
                return Array.factory((DataType)DataType.UINT, (int[])shape, (Object)bb.asIntBuffer().array());
            }
            case 10: {
                return Array.factory((DataType)DataType.LONG, (int[])shape, (Object)bb.asLongBuffer().array());
            }
            case 11: {
                return Array.factory((DataType)DataType.ULONG, (int[])shape, (Object)bb.asLongBuffer().array());
            }
        }
        throw new IllegalArgumentException("Illegal type=" + baseType);
    }

    private Attribute readOpaqueAttValues(int grpid, int varid, String attname, int len, UserType userType) throws IOException {
        int total = len * userType.size;
        byte[] bb = new byte[total];
        int ret = this.nc4.nc_get_att(grpid, varid, attname, bb);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        return Attribute.fromArray((String)attname, (Array)Array.factory((DataType)DataType.BYTE, (int[])new int[]{total}, (Object)bb));
    }

    private void readCompoundAttValues(int grpid, int varid, String attname, int len, UserType userType, List<Attribute> result, Variable.Builder<?> v) throws IOException {
        int buffSize = len * userType.size;
        byte[] bb = new byte[buffSize];
        int ret = this.nc4.nc_get_att(grpid, varid, attname, bb);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        ByteBuffer bbuff = ByteBuffer.wrap(bb);
        this.decodeCompoundData(len, userType, bbuff);
        if (v instanceof Structure.Builder) {
            Structure.Builder s = (Structure.Builder)v;
            for (Field fld : userType.flds) {
                Variable.Builder mv = s.findMemberVariable(fld.name).orElse(null);
                if (mv != null) {
                    mv.addAttribute(Attribute.fromArray((String)attname, (Array)fld.data));
                    continue;
                }
                result.add(Attribute.fromArray((String)(attname + "." + fld.name), (Array)fld.data));
            }
        } else {
            for (Field fld : userType.flds) {
                result.add(Attribute.fromArray((String)(attname + "." + fld.name), (Array)fld.data));
            }
        }
    }

    private void decodeCompoundData(int len, UserType userType, ByteBuffer bbuff) throws IOException {
        bbuff.order(ByteOrder.LITTLE_ENDIAN);
        for (Field fld : userType.flds) {
            ConvertedType ct = this.convertDataType(fld.fldtypeid);
            if (fld.fldtypeid == 2) {
                fld.data = Array.factory((DataType)DataType.STRING, (int[])new int[]{len});
                continue;
            }
            if (ct.isVlen) continue;
            fld.data = Array.factory((DataType)ct.dt, (int[])new int[]{len});
        }
        for (int i = 0; i < len; ++i) {
            int record_start = i * userType.size;
            block12: for (Field fld : userType.flds) {
                int pos = record_start + fld.offset;
                switch (fld.fldtypeid) {
                    case 2: {
                        int blen = 1;
                        if (fld.dims != null) {
                            Section s = new Section(fld.dims);
                            blen = (int)s.computeSize();
                        }
                        byte[] dst = new byte[blen];
                        bbuff.get(dst, 0, blen);
                        String cval = this.makeAttString(dst);
                        fld.data.setObject(i, (Object)cval);
                        continue block12;
                    }
                    case 1: 
                    case 7: {
                        byte bval = bbuff.get(pos);
                        fld.data.setByte(i, bval);
                        continue block12;
                    }
                    case 3: 
                    case 8: {
                        short sval = bbuff.getShort(pos);
                        fld.data.setShort(i, sval);
                        continue block12;
                    }
                    case 4: 
                    case 9: {
                        int ival = bbuff.getInt(pos);
                        fld.data.setInt(i, ival);
                        continue block12;
                    }
                    case 10: 
                    case 11: {
                        long lval = bbuff.getLong(pos);
                        fld.data.setLong(i, lval);
                        continue block12;
                    }
                    case 5: {
                        float fval = bbuff.getFloat(pos);
                        fld.data.setFloat(i, fval);
                        continue block12;
                    }
                    case 6: {
                        double dval = bbuff.getDouble(pos);
                        fld.data.setDouble(i, dval);
                        continue block12;
                    }
                    case 12: {
                        long lval = Nc4reader.getNativeAddr(pos, bbuff);
                        Pointer p = new Pointer(lval);
                        String strval = p.getString(0L, "UTF-8");
                        fld.data.setObject(i, (Object)strval);
                        continue block12;
                    }
                }
                UserType subUserType = this.userTypes.get(fld.fldtypeid);
                if (subUserType == null) {
                    throw new IOException("Unknown compound user type == " + fld);
                }
                if (subUserType.typeClass != 15) {
                    if (subUserType.typeClass == 13) {
                        this.decodeVlenField(fld, subUserType, pos, i, bbuff);
                        continue;
                    }
                    if (subUserType.typeClass == 14 || subUserType.typeClass == 16) {
                        // empty if block
                    }
                }
                log.warn("UNSUPPORTED compound fld.fldtypeid= " + fld.fldtypeid);
            }
        }
    }

    private void decodeVlenField(Field fld, UserType userType, int pos, int idx, ByteBuffer bbuff) throws IOException {
        ConvertedType cvt = this.convertDataType(userType.baseTypeid);
        Array array = this.decodeVlen(cvt.dt, pos, bbuff);
        fld.data.setObject(idx, (Object)array);
    }

    private Array decodeVlen(DataType dt, int pos, ByteBuffer bbuff) throws IOException {
        Object[] data;
        int n = (int)bbuff.getLong(pos);
        long addr = Nc4reader.getNativeAddr(pos + Native.POINTER_SIZE, bbuff);
        Pointer p = new Pointer(addr);
        switch (dt) {
            case ENUM1: 
            case BOOLEAN: 
            case BYTE: {
                data = p.getByteArray(0L, n);
                break;
            }
            case ENUM2: 
            case SHORT: {
                data = p.getShortArray(0L, n);
                break;
            }
            case ENUM4: 
            case INT: {
                data = p.getIntArray(0L, n);
                break;
            }
            case LONG: {
                data = p.getLongArray(0L, n);
                break;
            }
            case FLOAT: {
                data = p.getFloatArray(0L, n);
                break;
            }
            case DOUBLE: {
                data = p.getDoubleArray(0L, n);
                break;
            }
            case CHAR: {
                data = p.getCharArray(0L, n);
                break;
            }
            case STRING: {
                String[] stringdata = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringdata[i] = p.getString((long)(i * 8));
                }
                data = stringdata;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Array array = Array.factory((DataType)dt, (int[])new int[]{n}, (Object)data);
        return array;
    }

    private void makeVariables(Group4 g4) throws IOException {
        IntByReference nvarsp = new IntByReference();
        int ret = this.nc4.nc_inq_nvars(g4.grpid, nvarsp);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        int nvars = nvarsp.getValue();
        log.debug("nvars= {}", (Object)nvars);
        int[] varids = new int[nvars];
        ret = this.nc4.nc_inq_varids(g4.grpid, nvarsp, varids);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        for (int i = 0; i < varids.length; ++i) {
            IntByReference nattsp;
            int[] dimids;
            IntByReference ndimsp;
            IntByReference xtypep;
            byte[] name;
            int varno = varids[i];
            if (varno != i) {
                log.error("makeVariables varno={} is not equal to {}", (Object)varno, (Object)i);
            }
            if ((ret = this.nc4.nc_inq_var(g4.grpid, varno, name = new byte[257], xtypep = new IntByReference(), ndimsp = new IntByReference(), dimids = new int[1024], nattsp = new IntByReference())) != 0) {
                throw new IOException(this.nc4.nc_strerror(ret));
            }
            int typeid = xtypep.getValue();
            String vname = this.makeString(name);
            Vinfo vinfo = new Vinfo(g4, varno, typeid);
            String dimList = this.makeDimList(g4.grpid, ndimsp.getValue(), dimids);
            UserType utype = this.userTypes.get(typeid);
            if (utype != null) {
                vinfo.utype = utype;
                if (utype.typeClass == 13) {
                    dimList = dimList + " *";
                }
            }
            Variable.Builder<?> v = this.makeVariable(g4.g, vname, typeid, dimList);
            g4.g.addVariable(v);
            v.setSPobject((Object)vinfo);
            List<Attribute> atts = this.makeAttributes(g4.grpid, varno, nattsp.getValue(), v);
            for (Attribute att : atts) {
                v.addAttribute(att);
            }
            log.debug("added Variable {}", v);
        }
    }

    private Variable.Builder<?> makeVariable(Group.Builder g, String vname, int typeid, String dimList) throws IOException {
        Variable.Builder v;
        ConvertedType cvttype = this.convertDataType(typeid);
        DataType dtype = cvttype.dt;
        UserType utype = this.userTypes.get(typeid);
        if (dtype != DataType.STRUCTURE) {
            v = Variable.builder().setName(vname).setDataType(dtype).setParentGroupBuilder(g).setDimensionsByName(dimList);
        } else if (utype != null) {
            Structure.Builder s = (Structure.Builder)((Structure.Builder)((Structure.Builder)Structure.builder().setName(vname)).setParentGroupBuilder(g)).setDimensionsByName(dimList);
            v = s;
            if (utype.flds == null) {
                utype.readFields();
            }
            for (Field f : utype.flds) {
                s.addMemberVariable(f.makeMemberVariable(g));
            }
        } else {
            throw new IllegalStateException("Structure with no userType " + dtype);
        }
        if (dtype.isEnum()) {
            v.setEnumTypeName(utype.name);
        } else if (dtype != DataType.OPAQUE || this.markReserved) {
            // empty if block
        }
        return v;
    }

    private String makeDimList(int grpid, int ndimsp, int[] dims) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ndimsp; ++i) {
            byte[] name = new byte[257];
            int ret = this.nc4.nc_inq_dimname(grpid, dims[i], name);
            if (ret != 0) {
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            String dname = this.makeString(name);
            sb.append(dname);
            sb.append(" ");
        }
        return sb.toString();
    }

    private boolean nc_inq_var(Formatter f, int grpid, int varno) throws IOException {
        byte[] name = new byte[257];
        IntByReference xtypep = new IntByReference();
        IntByReference ndimsp = new IntByReference();
        int[] dimids = new int[1024];
        IntByReference nattsp = new IntByReference();
        int ret = this.nc4.nc_inq_var(grpid, varno, name, xtypep, ndimsp, dimids, nattsp);
        if (ret != 0) {
            return false;
        }
        String vname = this.makeString(name);
        int typeid = xtypep.getValue();
        ConvertedType cvt = this.convertDataType(typeid);
        for (int i = 0; i < ndimsp.getValue(); ++i) {
            f.format("%d ", dimids[i]);
        }
        String dimList = this.makeDimList(grpid, ndimsp.getValue(), dimids);
        f.format(") dims=(%s)%n", dimList);
        return true;
    }

    private String nc_inq_var_name(int grpid, int varno) throws IOException {
        byte[] name = new byte[257];
        IntByReference xtypep = new IntByReference();
        IntByReference ndimsp = new IntByReference();
        IntByReference nattsp = new IntByReference();
        int ret = this.nc4.nc_inq_var(grpid, varno, name, xtypep, ndimsp, null, nattsp);
        if (ret != 0) {
            throw new IOException("nc_inq_var faild: code=" + ret);
        }
        return this.makeString(name);
    }

    private void makeUserTypes(int grpid, Group.Builder g) throws IOException {
        IntByReference ntypesp = new IntByReference();
        int ret = this.nc4.nc_inq_typeids(grpid, ntypesp, null);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        int ntypes = ntypesp.getValue();
        if (ntypes == 0) {
            return;
        }
        int[] xtypes = new int[ntypes];
        ret = this.nc4.nc_inq_typeids(grpid, ntypesp, xtypes);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        for (int typeid : xtypes) {
            byte[] nameb = new byte[257];
            SizeTByReference sizep = new SizeTByReference();
            IntByReference baseType = new IntByReference();
            SizeTByReference nfieldsp = new SizeTByReference();
            IntByReference classp = new IntByReference();
            ret = this.nc4.nc_inq_user_type(grpid, typeid, nameb, sizep, baseType, nfieldsp, classp);
            if (ret != 0) {
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            String name = this.makeString(nameb);
            int utype = classp.getValue();
            log.debug("user type id={} name={} size={} baseType={} nfields={} class={}", new Object[]{typeid, name, sizep.getValue().longValue(), baseType.getValue(), nfieldsp.getValue().longValue(), utype});
            UserType ut = new UserType(grpid, typeid, name, sizep.getValue().longValue(), baseType.getValue(), nfieldsp.getValue().longValue(), utype);
            this.userTypes.put(typeid, ut);
            if (utype == 15) {
                Map<Integer, String> map = this.makeEnum(grpid, typeid);
                ut.e = new EnumTypedef(name, map, ut.getEnumBaseType());
                g.addEnumTypedef(ut.e);
                continue;
            }
            if (utype != 14) continue;
            byte[] nameo = new byte[257];
            SizeTByReference sizep2 = new SizeTByReference();
            ret = this.nc4.nc_inq_opaque(grpid, typeid, nameo, sizep2);
            if (ret != 0) {
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            ut.setSize(sizep2.getValue().intValue());
        }
    }

    private Map<Integer, String> makeEnum(int grpid, int xtype) throws IOException {
        byte[] nameb = new byte[257];
        IntByReference baseType = new IntByReference();
        SizeTByReference baseSize = new SizeTByReference();
        SizeTByReference numMembers = new SizeTByReference();
        int ret = this.nc4.nc_inq_enum(grpid, xtype, nameb, baseType, baseSize, numMembers);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        int nmembers = numMembers.getValue().intValue();
        HashMap<Integer, String> map = new HashMap<Integer, String>(2 * nmembers);
        for (int i = 0; i < nmembers; ++i) {
            byte[] mnameb = new byte[257];
            IntByReference value = new IntByReference();
            ret = this.nc4.nc_inq_enum_member(grpid, xtype, i, mnameb, value);
            if (ret != 0) {
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            String mname = this.makeString(mnameb);
            map.put(value.getValue(), mname);
        }
        return map;
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        int len;
        Vinfo vinfo = (Vinfo)v2.getSPobject();
        int vlen = (int)v2.getSize();
        if (vlen == (len = (int)section.computeSize())) {
            return this.readDataAll(vinfo.g4.grpid, vinfo.varid, vinfo.typeid, v2.getShapeAsSection());
        }
        return this.readDataSection(vinfo.g4.grpid, vinfo.varid, vinfo.typeid, section);
    }

    Array readDataSection(int grpid, int varid, int typeid, Section section) throws IOException, InvalidRangeException {
        Array values;
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        SizeT[] shape = this.convertSizeT(section.getShape());
        SizeT[] stride = this.convertSizeT(section.getStride());
        boolean isUnsigned = this.isUnsigned(typeid);
        int len = (int)section.computeSize();
        switch (typeid) {
            case 1: 
            case 7: {
                int ret;
                byte[] valb = new byte[len];
                int n = ret = isUnsigned ? this.nc4.nc_get_vars_uchar(grpid, varid, origin, shape, stride, valb) : this.nc4.nc_get_vars_schar(grpid, varid, origin, shape, stride, valb);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                values = Array.factory((DataType)DataType.BYTE, (int[])section.getShape(), (Object)valb);
                break;
            }
            case 2: {
                byte[] valc = new byte[len];
                int ret = this.nc4.nc_get_vars_text(grpid, varid, origin, shape, stride, valc);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                values = Array.factory((DataType)DataType.CHAR, (int[])section.getShape(), (Object)IospHelper.convertByteToChar((byte[])valc));
                break;
            }
            case 6: {
                double[] vald = new double[len];
                int ret = this.nc4.nc_get_vars_double(grpid, varid, origin, shape, stride, vald);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                values = Array.factory((DataType)DataType.DOUBLE, (int[])section.getShape(), (Object)vald);
                break;
            }
            case 5: {
                float[] valf = new float[len];
                int ret = this.nc4.nc_get_vars_float(grpid, varid, origin, shape, stride, valf);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                values = Array.factory((DataType)DataType.FLOAT, (int[])section.getShape(), (Object)valf);
                break;
            }
            case 4: 
            case 9: {
                int ret;
                int[] vali = new int[len];
                int n = ret = isUnsigned ? this.nc4.nc_get_vars_uint(grpid, varid, origin, shape, stride, vali) : this.nc4.nc_get_vars_int(grpid, varid, origin, shape, stride, vali);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                values = Array.factory((DataType)DataType.INT, (int[])section.getShape(), (Object)vali);
                break;
            }
            case 10: 
            case 11: {
                int ret;
                long[] vall = new long[len];
                int n = ret = isUnsigned ? this.nc4.nc_get_vars_ulonglong(grpid, varid, origin, shape, stride, vall) : this.nc4.nc_get_vars_longlong(grpid, varid, origin, shape, stride, vall);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                values = Array.factory((DataType)DataType.LONG, (int[])section.getShape(), (Object)vall);
                break;
            }
            case 3: 
            case 8: {
                int ret;
                short[] vals = new short[len];
                int n = ret = isUnsigned ? this.nc4.nc_get_vars_ushort(grpid, varid, origin, shape, stride, vals) : this.nc4.nc_get_vars_short(grpid, varid, origin, shape, stride, vals);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                values = Array.factory((DataType)DataType.SHORT, (int[])section.getShape(), (Object)vals);
                break;
            }
            case 12: {
                String[] valss = new String[len];
                int ret = this.nc4.nc_get_vars_string(grpid, varid, origin, shape, stride, valss);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                if (transcodeStrings) {
                    valss = this.transcodeString(valss);
                }
                return Array.factory((DataType)DataType.STRING, (int[])section.getShape(), (Object)valss);
            }
            default: {
                UserType userType = this.userTypes.get(typeid);
                if (userType == null) {
                    throw new IOException("Unknown userType == " + typeid);
                }
                if (userType.typeClass == 15) {
                    return this.readDataSection(grpid, varid, userType.baseTypeid, section);
                }
                if (userType.typeClass == 13) {
                    return this.readVlen(grpid, varid, userType, section);
                }
                if (userType.typeClass == 14) {
                    return this.readOpaque(grpid, varid, section, userType.size);
                }
                if (userType.typeClass == 16) {
                    return this.readCompound(grpid, varid, section, userType);
                }
                throw new IOException("Unsupported userType = " + typeid + " userType= " + userType);
            }
        }
        return values;
    }

    private Array readDataAll(int grpid, int varid, int typeid, Section section) throws IOException, InvalidRangeException {
        int len = (int)section.computeSize();
        int[] shape = section.getShape();
        switch (typeid) {
            case 7: {
                byte[] valbu = new byte[len];
                int ret = this.nc4.nc_get_var_ubyte(grpid, varid, valbu);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                return Array.factory((DataType)DataType.UBYTE, (int[])shape, (Object)valbu);
            }
            case 1: {
                byte[] valb = new byte[len];
                int ret = this.nc4.nc_get_var_schar(grpid, varid, valb);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                return Array.factory((DataType)DataType.BYTE, (int[])shape, (Object)valb);
            }
            case 2: {
                byte[] valc = new byte[len];
                int ret = this.nc4.nc_get_var_text(grpid, varid, valc);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                char[] cvals = IospHelper.convertByteToChar((byte[])valc);
                return Array.factory((DataType)DataType.CHAR, (int[])shape, (Object)cvals);
            }
            case 6: {
                double[] vald = new double[len];
                int ret = this.nc4.nc_get_var_double(grpid, varid, vald);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                return Array.factory((DataType)DataType.DOUBLE, (int[])shape, (Object)vald);
            }
            case 5: {
                float[] valf = new float[len];
                int ret = this.nc4.nc_get_var_float(grpid, varid, valf);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                return Array.factory((DataType)DataType.FLOAT, (int[])shape, (Object)valf);
            }
            case 4: {
                int[] vali = new int[len];
                int ret = this.nc4.nc_get_var_int(grpid, varid, vali);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                return Array.factory((DataType)DataType.INT, (int[])shape, (Object)vali);
            }
            case 10: {
                long[] vall = new long[len];
                int ret = this.nc4.nc_get_var_longlong(grpid, varid, vall);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                return Array.factory((DataType)DataType.LONG, (int[])shape, (Object)vall);
            }
            case 11: {
                long[] vallu = new long[len];
                int ret = this.nc4.nc_get_var_ulonglong(grpid, varid, vallu);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                return Array.factory((DataType)DataType.ULONG, (int[])shape, (Object)vallu);
            }
            case 3: {
                short[] vals = new short[len];
                int ret = this.nc4.nc_get_var_short(grpid, varid, vals);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                return Array.factory((DataType)DataType.SHORT, (int[])shape, (Object)vals);
            }
            case 8: {
                short[] valsu = new short[len];
                int ret = this.nc4.nc_get_var_ushort(grpid, varid, valsu);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                return Array.factory((DataType)DataType.USHORT, (int[])shape, (Object)valsu);
            }
            case 9: {
                int[] valiu = new int[len];
                int ret = this.nc4.nc_get_var_uint(grpid, varid, valiu);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                return Array.factory((DataType)DataType.UINT, (int[])shape, (Object)valiu);
            }
            case 12: {
                String[] valss = new String[len];
                int ret = this.nc4.nc_get_var_string(grpid, varid, valss);
                if (ret != 0) {
                    throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
                }
                if (transcodeStrings) {
                    valss = this.transcodeString(valss);
                }
                return Array.factory((DataType)DataType.STRING, (int[])shape, (Object)valss);
            }
        }
        UserType userType = this.userTypes.get(typeid);
        if (userType == null) {
            throw new IOException("Unknown userType == " + typeid);
        }
        if (userType.typeClass == 15) {
            int buffSize = len * userType.size;
            byte[] bbuff = new byte[buffSize];
            int ret = this.nc4.nc_get_var(grpid, varid, bbuff);
            if (ret != 0) {
                throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
            }
            ByteBuffer bb = ByteBuffer.wrap(bbuff);
            bb.order(ByteOrder.nativeOrder());
            switch (userType.baseTypeid) {
                case 1: {
                    return Array.factory((DataType)DataType.BYTE, (int[])shape, (ByteBuffer)bb);
                }
                case 7: {
                    return Array.factory((DataType)DataType.UBYTE, (int[])shape, (ByteBuffer)bb);
                }
                case 3: {
                    return Array.factory((DataType)DataType.SHORT, (int[])shape, (ByteBuffer)bb);
                }
                case 8: {
                    return Array.factory((DataType)DataType.USHORT, (int[])shape, (ByteBuffer)bb);
                }
                case 4: {
                    return Array.factory((DataType)DataType.INT, (int[])shape, (ByteBuffer)bb);
                }
                case 9: {
                    return Array.factory((DataType)DataType.UINT, (int[])shape, (ByteBuffer)bb);
                }
            }
            throw new IOException("unknown type " + userType.baseTypeid);
        }
        if (userType.typeClass == 13) {
            return this.readVlen(grpid, varid, userType, section);
        }
        if (userType.typeClass == 14) {
            return this.readOpaque(grpid, varid, section, userType.size);
        }
        if (userType.typeClass == 16) {
            return this.readCompound(grpid, varid, section, userType);
        }
        throw new IOException("Unsupported userType = " + typeid + " userType= " + userType);
    }

    private Array readCompound(int grpid, int varid, Section section, UserType userType) throws IOException {
        int len;
        int buffSize;
        byte[] bbuff;
        SizeT[] stride;
        SizeT[] shape;
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        int ret = this.nc4.nc_get_vars(grpid, varid, origin, shape = this.convertSizeT(section.getShape()), stride = this.convertSizeT(section.getStride()), bbuff = new byte[buffSize = (len = (int)section.computeSize()) * userType.size]);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        ByteBuffer bb = ByteBuffer.wrap(bbuff);
        bb.order(ByteOrder.nativeOrder());
        String vname = this.nc_inq_var_name(grpid, varid);
        StructureMembers sm = this.createStructureMembers(userType, vname);
        ArrayStructureBB asbb = new ArrayStructureBB(sm, section.getShape(), bb, 0);
        int destPos = 0;
        for (int i = 0; i < len; ++i) {
            this.convertHeap(asbb, destPos, sm);
            destPos += userType.size;
        }
        return asbb;
    }

    private StructureMembers createStructureMembers(UserType userType, String varname) {
        StructureMembers.Builder sm = StructureMembers.builder().setName(varname);
        for (Field fld : userType.flds) {
            StructureMembers.MemberBuilder mb = sm.addMember(fld.name, null, null, fld.ctype.dt, fld.dims);
            mb.setDataParam(fld.offset);
            if (fld.ctype.dt != DataType.STRUCTURE) continue;
            UserType nested_utype = this.userTypes.get(fld.fldtypeid);
            String partfqn = EscapeStrings.backslashEscapeCDMString((String)varname, (String)".") + "." + EscapeStrings.backslashEscapeCDMString((String)fld.name, (String)".");
            StructureMembers nested_sm = this.createStructureMembers(nested_utype, partfqn);
            mb.setStructureMembers(nested_sm);
        }
        sm.setStructureSize(userType.size);
        return sm.build();
    }

    private void convertHeap(ArrayStructureBB asbb, int pos, StructureMembers sm) throws IOException {
        ByteBuffer bb = asbb.getByteBuffer();
        for (StructureMembers.Member m : sm.getMembers()) {
            Array result;
            int prefixrank;
            if (m.getDataType() == DataType.STRING) {
                int size = m.getSize();
                int destPos = pos + m.getDataParam();
                String[] result2 = new String[size];
                for (int i = 0; i < size; ++i) {
                    long addr = Nc4reader.getNativeAddr(pos, bb);
                    Pointer p = new Pointer(addr);
                    result2[i] = p.getString(0L, "UTF-8");
                }
                int index = asbb.addObjectToHeap((Object)result2);
                bb.putInt(destPos, index);
                continue;
            }
            if (!m.isVariableLength()) continue;
            int nc_vlen_t_size = new Nc4prototypes.Vlen_t().size();
            int startPos = pos + m.getDataParam();
            int[] fieldshape = m.getShape();
            int size = 1;
            for (prefixrank = 0; prefixrank < fieldshape.length && fieldshape[prefixrank] >= 0; ++prefixrank) {
                size *= fieldshape[prefixrank];
            }
            assert (size == m.getSize()) : "Internal error: field size mismatch";
            Array[] fieldarray = new Array[size];
            int destPos = startPos;
            for (int i = 0; i < size; ++i) {
                Array vlenArray;
                fieldarray[i] = vlenArray = this.decodeVlen(m.getDataType(), destPos, bb);
                destPos += nc_vlen_t_size;
            }
            if (prefixrank == 0) {
                result = fieldarray[0];
            } else {
                int[] newshape = new int[prefixrank];
                System.arraycopy(fieldshape, 0, newshape, 0, prefixrank);
                result = Array.makeVlenArray((int[])newshape, (Array[])fieldarray);
            }
            int index = asbb.addObjectToHeap((Object)result);
            bb.order(ByteOrder.nativeOrder());
            bb.putInt(startPos, index);
        }
    }

    Array readVlen(int grpid, int varid, UserType userType, Section section) throws IOException {
        int prefixrank;
        int len = (int)section.computeSize();
        Nc4prototypes.Vlen_t[] vlen = new Nc4prototypes.Vlen_t[len];
        int ret = this.nc4.nc_get_var(grpid, varid, vlen);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        for (prefixrank = 0; prefixrank < section.getRank() && section.getRange(prefixrank) != Range.VLEN; ++prefixrank) {
        }
        ConvertedType ctype = this.convertDataType(userType.baseTypeid);
        Array[] data = new Array[len];
        switch (userType.baseTypeid) {
            case 4: 
            case 9: {
                Object[] ba;
                int slen;
                int i;
                for (i = 0; i < len; ++i) {
                    slen = vlen[i].len;
                    ba = vlen[i].p.getIntArray(0L, slen);
                    data[i] = Array.factory((DataType)ctype.dt, (int[])new int[]{slen}, (Object)ba);
                }
                break;
            }
            case 3: 
            case 8: {
                Object[] ba;
                int slen;
                int i;
                for (i = 0; i < len; ++i) {
                    slen = vlen[i].len;
                    ba = vlen[i].p.getShortArray(0L, slen);
                    data[i] = Array.factory((DataType)ctype.dt, (int[])new int[]{slen}, (Object)ba);
                }
                break;
            }
            case 5: {
                Object[] ba;
                int slen;
                int i;
                for (i = 0; i < len; ++i) {
                    slen = vlen[i].len;
                    ba = vlen[i].p.getFloatArray(0L, slen);
                    data[i] = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{slen}, (Object)ba);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Vlen type " + userType.baseTypeid + " = " + ctype);
            }
        }
        if (prefixrank == 0) {
            return data[0];
        }
        int[] shape = new int[prefixrank];
        for (int i = 0; i < prefixrank; ++i) {
            shape[i] = section.getRange(i).length();
        }
        Array ndimarray = Array.makeVlenArray((int[])shape, (Array[])data);
        return ndimarray;
    }

    private Array readOpaque(int grpid, int varid, Section section, int size) throws IOException {
        int[] intshape;
        int len;
        byte[] bbuff;
        SizeT[] stride;
        SizeT[] shape;
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        int ret = this.nc4.nc_get_vars(grpid, varid, origin, shape = this.convertSizeT(section.getShape()), stride = this.convertSizeT(section.getStride()), bbuff = new byte[(len = (int)section.computeSize()) * size]);
        if (ret != 0) {
            throw new IOException(ret + ": " + this.nc4.nc_strerror(ret));
        }
        if (shape != null) {
            intshape = new int[shape.length];
            for (int i = 0; i < intshape.length; ++i) {
                intshape[i] = shape[i].intValue();
            }
        } else {
            intshape = new int[]{1};
        }
        Array values = Array.factory((DataType)DataType.OPAQUE, (int[])intshape);
        int count = 0;
        IndexIterator ii = values.getIndexIterator();
        while (ii.hasNext()) {
            ii.setObjectNext((Object)ByteBuffer.wrap(bbuff, count * size, size));
            ++count;
        }
        return values;
    }

    boolean isUnsigned(int type) {
        return type == 7 || type == 8 || type == 9 || type == 11;
    }

    private boolean isVlen(int type) {
        UserType userType = this.userTypes.get(type);
        return userType != null && userType.typeClass == 13;
    }

    @Nullable
    SizeT[] convertSizeT(int[] from) {
        if (from.length == 0) {
            return null;
        }
        SizeT[] to = new SizeT[from.length];
        for (int i = 0; i < from.length; ++i) {
            to[i] = new SizeT(from[i]);
        }
        return to;
    }

    private ConvertedType convertDataType(int type) {
        switch (type) {
            case 1: {
                return new ConvertedType(DataType.BYTE);
            }
            case 7: {
                return new ConvertedType(DataType.UBYTE);
            }
            case 2: {
                return new ConvertedType(DataType.CHAR);
            }
            case 3: {
                return new ConvertedType(DataType.SHORT);
            }
            case 8: {
                return new ConvertedType(DataType.USHORT);
            }
            case 4: {
                return new ConvertedType(DataType.INT);
            }
            case 9: {
                return new ConvertedType(DataType.UINT);
            }
            case 10: {
                return new ConvertedType(DataType.LONG);
            }
            case 11: {
                return new ConvertedType(DataType.ULONG);
            }
            case 5: {
                return new ConvertedType(DataType.FLOAT);
            }
            case 6: {
                return new ConvertedType(DataType.DOUBLE);
            }
            case 15: {
                return new ConvertedType(DataType.ENUM1);
            }
            case 12: {
                return new ConvertedType(DataType.STRING);
            }
        }
        UserType userType = this.userTypes.get(type);
        if (userType == null) {
            throw new IllegalArgumentException("unknown type == " + type);
        }
        switch (userType.typeClass) {
            case 15: {
                switch (userType.size) {
                    case 1: {
                        return new ConvertedType(DataType.ENUM1);
                    }
                    case 2: {
                        return new ConvertedType(DataType.ENUM2);
                    }
                    case 4: {
                        return new ConvertedType(DataType.ENUM4);
                    }
                }
                throw new IllegalArgumentException("enum unknown size == " + userType);
            }
            case 16: {
                return new ConvertedType(DataType.STRUCTURE);
            }
            case 14: {
                return new ConvertedType(DataType.OPAQUE);
            }
            case 13: {
                ConvertedType result = this.convertDataType(userType.baseTypeid);
                result.isVlen = true;
                return result;
            }
        }
        throw new IllegalArgumentException("unknown type == " + type);
    }

    private String getDataTypeName(int type) {
        switch (type) {
            case 1: {
                return "byte";
            }
            case 7: {
                return "ubyte";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "short";
            }
            case 8: {
                return "ushort";
            }
            case 4: {
                return "int";
            }
            case 9: {
                return "uint";
            }
            case 10: {
                return "long";
            }
            case 11: {
                return "ulong";
            }
            case 5: {
                return "float";
            }
            case 6: {
                return "double";
            }
            case 15: {
                return "enum";
            }
            case 12: {
                return "string";
            }
            case 16: {
                return "struct";
            }
            case 14: {
                return "opaque";
            }
            case 13: {
                return "vlen";
            }
        }
        UserType userType = this.userTypes.get(type);
        if (userType == null) {
            return "unknown type " + type;
        }
        switch (userType.typeClass) {
            case 15: {
                return "userType-enum";
            }
            case 16: {
                return "userType-struct";
            }
            case 14: {
                return "userType-opaque";
            }
            case 13: {
                return "userType-vlen";
            }
        }
        return "unknown userType " + userType.typeClass;
    }

    private static long getNativeAddr(int pos, ByteBuffer buf) {
        return Platform.is64Bit() ? buf.getLong(pos) : (long)buf.getInt(pos);
    }

    class Field {
        int grpid;
        int typeid;
        int fldidx;
        String name;
        int offset;
        int fldtypeid;
        int ndims;
        int[] dims;
        ConvertedType ctype;
        Array data;

        Field(int grpid, int typeid, int fldidx, String name, int offset, int fldtypeid, int ndims, int[] dimz) {
            this.grpid = grpid;
            this.typeid = typeid;
            this.fldidx = fldidx;
            this.name = name;
            this.offset = offset;
            this.fldtypeid = fldtypeid;
            this.ndims = ndims;
            this.dims = new int[ndims];
            System.arraycopy(dimz, 0, this.dims, 0, ndims);
            this.ctype = Nc4reader.this.convertDataType(fldtypeid);
            if (Nc4reader.this.isVlen(fldtypeid)) {
                int[] edims = new int[ndims + 1];
                if (ndims > 0) {
                    System.arraycopy(dimz, 0, edims, 0, ndims);
                }
                edims[ndims] = -1;
                this.dims = edims;
                ++this.ndims;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return this.grpid == field.grpid && this.typeid == field.typeid && this.fldidx == field.fldidx && this.offset == field.offset && this.fldtypeid == field.fldtypeid && this.ndims == field.ndims && Objects.equals(this.name, field.name) && Arrays.equals(this.dims, field.dims);
        }

        public int hashCode() {
            return Objects.hash(this.grpid, this.typeid, this.fldidx, this.name, this.offset, this.fldtypeid, this.ndims, this.dims);
        }

        public String toString2() {
            return "name='" + this.name + " fldtypeid=" + Nc4reader.this.getDataTypeName(this.fldtypeid) + " ndims=" + this.ndims + " offset=" + this.offset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Field");
            sb.append("{grpid=").append(this.grpid);
            sb.append(", typeid=").append(this.typeid);
            sb.append(", fldidx=").append(this.fldidx);
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", offset=").append(this.offset);
            sb.append(", fldtypeid=").append(this.fldtypeid);
            sb.append(", ndims=").append(this.ndims);
            sb.append(", dims=").append(this.dims == null ? "null" : "");
            for (int i = 0; this.dims != null && i < this.dims.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.dims[i]);
            }
            sb.append(", dtype=").append(this.ctype.dt);
            if (this.ctype.isVlen) {
                sb.append("(vlen)");
            }
            sb.append('}');
            return sb.toString();
        }

        Variable.Builder<?> makeMemberVariable(Group.Builder g) throws IOException {
            Variable.Builder v = Nc4reader.this.makeVariable(g, this.name, this.fldtypeid, "");
            v.setDimensionsAnonymous(this.dims);
            return v;
        }
    }

    class UserType {
        int grpid;
        int typeid;
        String name;
        int size;
        int baseTypeid;
        long nfields;
        int typeClass;
        EnumTypedef e;
        List<Field> flds;

        UserType(int grpid, int typeid, String name, long size, int baseTypeid, long nfields, int typeClass) throws IOException {
            this.grpid = grpid;
            this.typeid = typeid;
            this.name = name;
            this.size = (int)size;
            this.baseTypeid = baseTypeid;
            this.nfields = nfields;
            this.typeClass = typeClass;
            if (typeClass == 16) {
                this.readFields();
            }
        }

        public UserType setSize(int size) {
            this.size = size;
            return this;
        }

        DataType getEnumBaseType() {
            if (this.baseTypeid > 0 && this.baseTypeid <= 12) {
                DataType cdmtype;
                switch (this.baseTypeid) {
                    case 1: 
                    case 2: 
                    case 7: {
                        cdmtype = DataType.ENUM1;
                        break;
                    }
                    case 3: 
                    case 8: {
                        cdmtype = DataType.ENUM2;
                        break;
                    }
                    default: {
                        cdmtype = DataType.ENUM4;
                    }
                }
                return cdmtype;
            }
            return null;
        }

        void addField(Field fld) {
            if (this.flds == null) {
                this.flds = new ArrayList<Field>(10);
            }
            this.flds.add(fld);
        }

        void setFields(List<Field> flds) {
            this.flds = flds;
        }

        public String toString2() {
            return "name='" + this.name + "' id=" + Nc4reader.this.getDataTypeName(this.typeid) + " userType=" + Nc4reader.this.getDataTypeName(this.typeClass) + " baseType=" + Nc4reader.this.getDataTypeName(this.baseTypeid);
        }

        public String toString() {
            return "UserType{grpid=" + this.grpid + ", typeid=" + this.typeid + ", name='" + this.name + '\'' + ", size=" + this.size + ", baseTypeid=" + this.baseTypeid + ", nfields=" + this.nfields + ", typeClass=" + this.typeClass + ", e=" + this.e + '}';
        }

        void readFields() throws IOException {
            int fldidx = 0;
            while ((long)fldidx < this.nfields) {
                byte[] fldname = new byte[257];
                SizeTByReference offsetp = new SizeTByReference();
                IntByReference field_typeidp = new IntByReference();
                IntByReference ndimsp = new IntByReference();
                int[] dims = new int[1024];
                int ret = Nc4reader.this.nc4.nc_inq_compound_field(this.grpid, this.typeid, fldidx, fldname, offsetp, field_typeidp, ndimsp, dims);
                if (ret != 0) {
                    throw new IOException(ret + ": " + Nc4reader.this.nc4.nc_strerror(ret));
                }
                Field fld = new Field(this.grpid, this.typeid, fldidx, Nc4reader.this.makeString(fldname), offsetp.getValue().intValue(), field_typeidp.getValue(), ndimsp.getValue(), dims);
                this.addField(fld);
                ++fldidx;
            }
        }
    }

    static class Group4 {
        final int grpid;
        final Group.Builder g;
        final Group4 parent;
        Map<Dimension, Integer> dimHash;

        Group4(int grpid, Group.Builder g, Group4 parent) {
            this.grpid = grpid;
            this.g = g;
            this.parent = parent;
        }
    }

    static class Vinfo {
        final Group4 g4;
        int varid;
        int typeid;
        UserType utype;

        Vinfo(Group4 g4, int varid, int typeid) {
            this.g4 = g4;
            this.varid = varid;
            this.typeid = typeid;
        }
    }

    private static class ConvertedType {
        DataType dt;
        boolean isVlen;

        ConvertedType(DataType dt) {
            this.dt = dt;
        }
    }
}

