/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.HTTPAuthUtil;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPSession;

public class HTTPAuthStore
implements Serializable {
    public static Logger log = LoggerFactory.getLogger(HTTPSession.class);
    public static boolean TESTING = false;
    protected Map<String, List<Scope>> rows = new HashMap<String, List<Scope>>();
    protected HTTPAuthStore parent = null;

    public HTTPAuthStore() {
    }

    public HTTPAuthStore(HTTPAuthStore parent) {
        this();
        this.parent = parent;
    }

    public synchronized CredentialsProvider insert(AuthScope scope, CredentialsProvider provider) throws HTTPException {
        if (scope == null) {
            scope = AuthScope.ANY;
        }
        if (provider == null) {
            throw new HTTPException("HTTPAuthStore.insert: null provider");
        }
        String scheme = scope.getScheme();
        if (scheme == AuthScope.ANY_SCHEME) {
            scheme = "";
        }
        List<Scope> scopes = this.getScopes(scheme);
        CredentialsProvider old = null;
        for (Scope sc : scopes) {
            if (!HTTPAuthUtil.equals(sc.scope, scope)) continue;
            old = sc.provider;
            sc.provider = provider;
            break;
        }
        if (old == null) {
            scopes.add(new Scope(scope, provider));
        }
        return old;
    }

    public synchronized CredentialsProvider remove(AuthScope scope) throws HTTPException {
        if (scope == null) {
            throw new HTTPException("HTTPAuthStore.remove: null scope");
        }
        String scheme = scope.getScheme();
        if (scheme == null) {
            throw new HTTPException("HTTPAuthStore.remove: null scheme");
        }
        List<Scope> scopes = this.getScopes(scheme);
        Scope old = null;
        for (Scope e : scopes) {
            if (!e.scope.equals((Object)scope)) continue;
            old = e;
            break;
        }
        if (old != null) {
            scopes.remove(old);
        }
        return old.provider;
    }

    public synchronized void clear() {
        this.rows.clear();
    }

    public synchronized List<Scope> getAllRows() {
        ArrayList<Scope> allrows = new ArrayList<Scope>();
        for (Map.Entry<String, List<Scope>> e : this.rows.entrySet()) {
            allrows.addAll(e.getValue());
        }
        return allrows;
    }

    public synchronized CredentialsProvider lookup(AuthScope scope) {
        if (scope == null || scope.getScheme() == null) {
            throw new IllegalArgumentException("null value");
        }
        List<Scope> scopes = this.getScopes(scope.getScheme());
        for (Scope sc : scopes) {
            if (!HTTPAuthUtil.equals(sc.scope, scope)) continue;
            return sc.provider;
        }
        scopes = this.getScopes("");
        for (Scope sc : scopes) {
            if (!HTTPAuthUtil.equals(sc.scope, scope)) continue;
            return sc.provider;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookup(scope);
    }

    protected List<Scope> getScopes(String scheme) {
        List<Scope> scopes = this.rows.get(scheme);
        if (scopes == null) {
            scopes = new ArrayList<Scope>();
            this.rows.put(scheme, scopes);
        }
        return scopes;
    }

    public static class Scope {
        public AuthScope scope;
        public CredentialsProvider provider;

        public Scope(AuthScope scope, CredentialsProvider provider) {
            this.scope = scope;
            this.provider = provider;
        }

        public String toString() {
            String p2 = this.provider == null ? "<>" : this.provider.toString();
            return String.format("%s{%s}", this.scope.toString(), p2);
        }
    }
}

