/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpclient;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import ucar.httpclient.HTTPSession;

public class CustomX509TrustManager
implements X509TrustManager {
    public static Logger logger = HTTPSession.log;
    protected static boolean verifyserver = false;
    protected static boolean allowselfsigned = false;
    private X509TrustManager standardTrustManager = null;

    public static void setVerifyServer(boolean tf) {
        verifyserver = tf;
    }

    public static void setAllowSelfSigned(boolean tf) {
        allowselfsigned = tf;
    }

    public CustomX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && logger.isDebugEnabled()) {
            logger.debug("Server certificate chain:");
            for (int i = 0; i < certificates.length; ++i) {
                logger.debug("X509Certificate[" + i + "]=" + certificates[i]);
            }
        }
        if (verifyserver) {
            if (allowselfsigned && certificates != null && certificates.length == 1) {
                X509Certificate certificate = certificates[0];
                certificate.checkValidity();
                if (!certificate.getIssuerDN().equals(certificate.getSubjectDN())) {
                    this.standardTrustManager.checkServerTrusted(certificates, authType);
                }
            } else {
                this.standardTrustManager.checkServerTrusted(certificates, authType);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

