/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.coord.TimeCoordIntvValue;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class TimeCoordIntvDateValue
implements Comparable<TimeCoordIntvDateValue> {
    private final CalendarDate start;
    private final CalendarDate end;

    public TimeCoordIntvDateValue(CalendarPeriod period, CalendarDate end) {
        this.end = end;
        this.start = end.subtract(period);
    }

    public TimeCoordIntvDateValue(CalendarDate start, CalendarPeriod period) {
        this.start = start;
        this.end = start.add(period);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeCoordIntvDateValue that = (TimeCoordIntvDateValue)o;
        return this.start.equals((Object)that.start) && this.end.equals((Object)that.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public TimeCoordIntvDateValue(CalendarDate start, CalendarDate end) {
        this.start = start;
        this.end = end;
    }

    public CalendarDate getStart() {
        return this.start;
    }

    public CalendarDate getEnd() {
        return this.end;
    }

    public TimeCoordIntvValue convertReferenceDate(CalendarDate refDate, CalendarPeriod timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("null time unit");
        }
        int startOffset = timeUnit.getOffset(refDate, this.start);
        int endOffset = timeUnit.getOffset(this.start, this.end) + startOffset;
        return new TimeCoordIntvValue(startOffset, endOffset);
    }

    @Override
    public int compareTo(@Nonnull TimeCoordIntvDateValue that) {
        int c1 = this.start.compareTo(that.start);
        return c1 == 0 ? this.end.compareTo(that.end) : c1;
    }

    public String toString() {
        return String.format("(%s,%s)", this.start, this.end);
    }
}

