/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2TableConfig;
import ucar.nc2.grib.grib2.table.LocalTables;
import ucar.nc2.util.TableParser;

public class KmaLocalTables
extends LocalTables {
    KmaLocalTables(Grib2TableConfig config) {
        super(config);
        this.initLocalTable();
    }

    private void initLocalTable() {
        String tablePath = this.config.getPath();
        ClassLoader cl = KmaLocalTables.class.getClassLoader();
        try (InputStream is = cl.getResourceAsStream(tablePath);){
            if (is == null) {
                throw new IllegalStateException("Cant find " + tablePath);
            }
            List recs = TableParser.readTable((InputStream)is, (String)"41,112,124i,136i,148i,160", (int)1000);
            for (TableParser.Record record : recs) {
                String name = (String)record.get(0);
                int disc = (Integer)record.get(2);
                int cat = (Integer)record.get(3);
                int param = (Integer)record.get(4);
                String unit = (String)record.get(5);
                Grib2Parameter s = new Grib2Parameter(disc, cat, param, name, unit, null, null);
                this.localParams.put(KmaLocalTables.makeParamId(disc, cat, param), s);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

