/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.coord.VertCoordType;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;

public class FnmocTables
extends Grib1Customizer {
    private static final Logger logger = LoggerFactory.getLogger(FnmocTables.class);
    private static final String fnmocTableA = "resources/grib1/fnmoc/US058MMTA-ALPdoc.pntabs-prodname-masterModelTableOrdered.GRIB1.TblA.xml";
    private static final String fnmocTable2 = "resources/grib1/fnmoc/US058MMTA-ALPdoc.pntabs-prodname-masterParameterTableOrdered.GRIB1.Tbl2.xml";
    private static final String fnmocTable3 = "resources/grib1/fnmoc/US058MMTA-ALPdoc.pntabs-prodname-masterLevelTypeTableOrdered.GRIB1.Tbl3.xml";
    private static Map<Integer, VertCoordType> levelTypesMap;
    private static Map<Integer, String> genProcessMap;

    FnmocTables(Grib1ParamTables tables) {
        super(58, tables);
    }

    @Override
    @Nullable
    public String getGeneratingProcessName(int genProcess) {
        if (genProcessMap == null) {
            genProcessMap = this.readGenProcess(fnmocTableA);
        }
        if (genProcessMap == null) {
            return null;
        }
        return genProcessMap.get(genProcess);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Map<Integer, String> readGenProcess(String path) {
        try (InputStream is = GribResourceReader.getInputStream(path);){
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, String> result = new HashMap<Integer, String>(200);
            Element fnmocTable = root.getChild("fnmocTable");
            List params = fnmocTable.getChildren("entry");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getChildText("grib1Id"));
                String desc = elem1.getChildText("fullName");
                result.put(code, desc);
            }
            Map map = Collections.unmodifiableMap(result);
            return map;
        }
        catch (IOException | JDOMException e) {
            logger.error("Cant read FNMOC Table 1 = " + path, e);
            return null;
        }
    }

    @Override
    protected VertCoordType getLevelType(int code) {
        if (levelTypesMap == null) {
            levelTypesMap = this.readFnmocTable3(fnmocTable3);
        }
        if (levelTypesMap == null) {
            return super.getLevelType(code);
        }
        VertCoordType levelType = levelTypesMap.get(code);
        if (levelType != null) {
            return levelType;
        }
        return super.getLevelType(code);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private HashMap<Integer, VertCoordType> readFnmocTable3(String path) {
        try (InputStream is = GribResourceReader.getInputStream(path);){
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, VertCoordType> result = new HashMap<Integer, VertCoordType>(200);
            Element fnmocTable = root.getChild("fnmocTable");
            List params = fnmocTable.getChildren("entry");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getChildText("grib1Id"));
                if (code < 129) continue;
                String desc = elem1.getChildText("description");
                String abbrev = elem1.getChildText("name");
                String units = elem1.getChildText("units");
                if (units == null) {
                    units = code == 219 ? "Pa" : "";
                }
                String datum = elem1.getChildText("datum");
                boolean isLayer = elem1.getChild("isLayer") != null;
                boolean isPositiveUp = elem1.getChild("isPositiveUp") != null;
                VertCoordType lt = new VertCoordType(code, desc, abbrev, units, datum, isPositiveUp, isLayer);
                result.put(code, lt);
            }
            HashMap<Integer, VertCoordType> hashMap = result;
            return hashMap;
        }
        catch (IOException | JDOMException e) {
            logger.error("Cant read FnmocTable3 = " + path, e);
            return null;
        }
    }
}

