/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import com.google.common.base.MoreObjects;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.grib.QuasiRegular;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.GaussianLatitudes;
import ucar.unidata.util.StringUtil2;

@Immutable
public class GdsHorizCoordSys {
    private static final Logger log = LoggerFactory.getLogger(GdsHorizCoordSys.class);
    private final String name;
    public final int template;
    public final int gdsNumberPoints;
    public final int scanMode;
    public final ProjectionImpl proj;
    public final double startx;
    public final double dx;
    public final double starty;
    public final double dy;
    public final int nx;
    public final int ny;
    public final int nxRaw;
    public final int nyRaw;
    public final int[] nptsInLine;
    private Array gaussLats;
    private Array gaussw;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GdsHorizCoordSys(String name, int template, int gdsNumberPoints, int scanMode, ProjectionImpl proj, double startx, double dx, double starty, double dy, int nxRaw, int nyRaw, int[] nptsInLine) {
        this.name = name;
        this.template = template;
        this.gdsNumberPoints = gdsNumberPoints;
        this.scanMode = scanMode;
        this.proj = proj;
        this.startx = startx;
        this.dx = dx;
        this.starty = starty;
        this.dy = dy;
        this.nxRaw = nxRaw;
        this.nyRaw = nyRaw;
        this.nptsInLine = nptsInLine;
        if (nptsInLine != null) {
            if (nxRaw > 0) {
                this.nx = nxRaw;
                this.ny = QuasiRegular.getMax(nptsInLine);
                return;
            } else {
                if (nyRaw <= 0) throw new IllegalArgumentException("Quasi Grids nx,ny=" + nxRaw + "," + nyRaw);
                this.ny = nyRaw;
                this.nx = QuasiRegular.getMax(nptsInLine);
            }
            return;
        } else {
            this.nx = nxRaw;
            this.ny = nyRaw;
        }
    }

    public String getName() {
        return this.name;
    }

    public double getStartX() {
        return this.startx;
    }

    public double getStartY() {
        if (this.gaussLats != null) {
            return this.gaussLats.getDouble(0);
        }
        return this.starty;
    }

    public double getEndX() {
        return this.startx + this.dx * (double)(this.nx - 1);
    }

    public double getEndY() {
        if (this.gaussLats != null) {
            return this.gaussLats.getDouble((int)this.gaussLats.getSize() - 1);
        }
        return this.starty + this.dy * (double)(this.ny - 1);
    }

    public int getScanMode() {
        return this.scanMode;
    }

    public boolean isLatLon() {
        return this.proj instanceof LatLonProjection;
    }

    public LatLonPoint getCenterLatLon() {
        return this.proj.projToLatLon(this.startx + this.dx * (double)this.nx / 2.0, this.starty + this.dy * (double)this.ny / 2.0);
    }

    public String makeDescription() {
        return this.name + "_" + this.ny + "X" + this.nx + " (Center " + this.getCenterLatLon() + ")";
    }

    public String makeId() {
        LatLonPoint center = this.getCenterLatLon();
        StringBuilder result = new StringBuilder(this.name + "_" + this.ny + "X" + this.nx + "-" + LatLonPoints.toString((LatLonPoint)center, (int)2));
        StringUtil2.replace((StringBuilder)result, (String)". ", (String)"p-");
        return result.toString();
    }

    public ProjectionRect getProjectionBB() {
        return new ProjectionRect(ProjectionPoint.create((double)this.getStartX(), (double)this.getStartY()), this.getEndX() - this.getStartX(), this.getEndY() - this.getStartY());
    }

    public LatLonRect getLatLonBB() {
        if (this.isLatLon()) {
            return new LatLonRect(LatLonPoint.create((double)this.getStartY(), (double)this.getStartX()), this.dy * (double)(this.ny - 1), this.dx * (double)(this.nx - 1));
        }
        return this.proj.projToLatLonBB(this.getProjectionBB());
    }

    public void setGaussianLats(int nparallels, float la1, float la2) {
        log.debug("la1 {}, la2 {}", (Object)Float.valueOf(la1), (Object)Float.valueOf(la2));
        if (this.gaussLats != null) {
            throw new RuntimeException("Cant modify GdsHorizCoordSys");
        }
        int nlats = 2 * nparallels;
        GaussianLatitudes gaussLats = GaussianLatitudes.factory((int)nlats);
        int bestStartIndex = 0;
        int bestEndIndex = 0;
        double bestStartDiff = Double.MAX_VALUE;
        double bestEndDiff = Double.MAX_VALUE;
        for (int i = 0; i < nlats; ++i) {
            double diff = Math.abs(gaussLats.latd[i] - (double)la1);
            if (diff < bestStartDiff) {
                bestStartDiff = diff;
                bestStartIndex = i;
            }
            if (!((diff = Math.abs(gaussLats.latd[i] - (double)la2)) < bestEndDiff)) continue;
            bestEndDiff = diff;
            bestEndIndex = i;
        }
        log.debug("first pass: bestStartIndex {}, bestEndIndex {}", (Object)bestStartIndex, (Object)bestEndIndex);
        if (Math.abs(bestEndIndex - bestStartIndex) + 1 != this.nyRaw) {
            log.warn("GRIB gaussian lats: NP != NY, use NY");
            nlats = this.nyRaw;
            gaussLats = GaussianLatitudes.factory((int)nlats);
            bestStartIndex = 0;
            bestEndIndex = this.nyRaw - 1;
        }
        boolean goesUp = bestEndIndex > bestStartIndex;
        log.debug("bestStartIndex {}, bestEndIndex {}, goesUp {}", new Object[]{bestStartIndex, bestEndIndex, goesUp});
        int useIndex = bestStartIndex;
        float[] data = new float[this.nyRaw];
        float[] gaussw = new float[this.nyRaw];
        for (int i = 0; i < this.nyRaw; ++i) {
            data[i] = (float)gaussLats.latd[useIndex];
            gaussw[i] = (float)gaussLats.gaussw[useIndex];
            log.trace("i {}, useIndex {}, data {}, gaussw {}", new Object[]{i, useIndex, Float.valueOf(data[i]), Float.valueOf(gaussw[i])});
            if (goesUp) {
                ++useIndex;
                continue;
            }
            --useIndex;
        }
        this.gaussLats = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{this.nyRaw}, (Object)data);
        this.gaussw = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{this.nyRaw}, (Object)gaussw);
    }

    public Array getGaussianLats() {
        return this.gaussLats;
    }

    public Array getGaussianWeights() {
        return this.gaussw;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("template", this.template).add("gdsNumberPoints", this.gdsNumberPoints).add("scanMode", this.scanMode).add("proj", (Object)this.proj).add("startx", this.startx).add("dx", this.dx).add("starty", this.starty).add("dy", this.dy).add("nx", this.nx).add("ny", this.ny).add("nxRaw", this.nxRaw).add("nyRaw", this.nyRaw).add("nptsInLine", (Object)this.nptsInLine).add("gaussLats", (Object)this.gaussLats).add("gaussw", (Object)this.gaussw).toString();
    }
}

