/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import ucar.nc2.grib.grib2.table.Grib2CodeTableInterface;
import ucar.nc2.grib.grib2.table.WmoCodeFlagTables;

public class WmoCodeTable
implements Grib2CodeTableInterface {
    private final WmoCodeFlagTables.WmoTable wmoTable;
    private final ImmutableMap<Integer, WmoCodeEntry> entryMap;

    WmoCodeTable(WmoCodeFlagTables.WmoTable wmoTable) {
        Preconditions.checkNotNull((Object)wmoTable);
        Preconditions.checkArgument((wmoTable.getType() == WmoCodeFlagTables.TableType.code || wmoTable.getType() == WmoCodeFlagTables.TableType.cat ? 1 : 0) != 0);
        this.wmoTable = wmoTable;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        wmoTable.getEntries().forEach(e -> builder.put((Object)e.getNumber(), (Object)new WmoCodeEntry((WmoCodeFlagTables.WmoTable.WmoEntry)e)));
        this.entryMap = builder.build();
    }

    @Override
    public String getName() {
        return this.wmoTable.getName();
    }

    @Override
    public String getShortName() {
        return "WMO " + this.wmoTable.getId();
    }

    @Override
    public ImmutableList<Grib2CodeTableInterface.Entry> getEntries() {
        return ImmutableList.copyOf((Collection)this.entryMap.values());
    }

    @Override
    public Grib2CodeTableInterface.Entry getEntry(int codeValue) {
        return (Grib2CodeTableInterface.Entry)this.entryMap.get((Object)codeValue);
    }

    private static class WmoCodeEntry
    implements Grib2CodeTableInterface.Entry {
        private final WmoCodeFlagTables.WmoTable.WmoEntry entry;

        public WmoCodeEntry(WmoCodeFlagTables.WmoTable.WmoEntry entry) {
            this.entry = entry;
        }

        @Override
        public int getCode() {
            return this.entry.getNumber();
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }
    }
}

