/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import com.google.common.base.MoreObjects;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.jpeg.colorspace.ColorSpace;
import ucar.jpeg.colorspace.ColorSpaceException;
import ucar.jpeg.icc.ICCProfiler;
import ucar.jpeg.jj2000.j2k.codestream.HeaderInfo;
import ucar.jpeg.jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import ucar.jpeg.jj2000.j2k.codestream.reader.HeaderDecoder;
import ucar.jpeg.jj2000.j2k.decoder.Decoder;
import ucar.jpeg.jj2000.j2k.decoder.DecoderSpecs;
import ucar.jpeg.jj2000.j2k.entropy.decoder.CodedCBlkDataSrcDec;
import ucar.jpeg.jj2000.j2k.entropy.decoder.EntropyDecoder;
import ucar.jpeg.jj2000.j2k.fileformat.reader.FileFormatReader;
import ucar.jpeg.jj2000.j2k.image.BlkImgDataSrc;
import ucar.jpeg.jj2000.j2k.image.Coord;
import ucar.jpeg.jj2000.j2k.image.DataBlk;
import ucar.jpeg.jj2000.j2k.image.DataBlkInt;
import ucar.jpeg.jj2000.j2k.image.ImgDataConverter;
import ucar.jpeg.jj2000.j2k.image.invcomptransf.InvCompTransf;
import ucar.jpeg.jj2000.j2k.image.output.ImgWriter;
import ucar.jpeg.jj2000.j2k.io.RandomAccessIO;
import ucar.jpeg.jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import ucar.jpeg.jj2000.j2k.quantization.dequantizer.Dequantizer;
import ucar.jpeg.jj2000.j2k.roi.ROIDeScaler;
import ucar.jpeg.jj2000.j2k.util.ISRandomAccessIO;
import ucar.jpeg.jj2000.j2k.util.ParameterList;
import ucar.jpeg.jj2000.j2k.util.StringFormatException;
import ucar.jpeg.jj2000.j2k.wavelet.synthesis.CBlkWTDataSrcDec;
import ucar.jpeg.jj2000.j2k.wavelet.synthesis.InverseWT;

public class Grib2JpegDecoder {
    private static final Logger logger = LoggerFactory.getLogger(Grib2JpegDecoder.class);
    private boolean debug;
    private final int rate;
    private int packBytes;
    private ColorSpace csMap;
    private int exitCode;
    private final ParameterList pl;
    private boolean hasSignedProblem;
    private int[] data;

    Grib2JpegDecoder(int nbits, boolean debug) {
        this.rate = nbits;
        this.debug = debug;
        String[] argv = new String[]{"-rate", Integer.toString(nbits), "-verbose", "off", "-debug", "on"};
        ParameterList defpl = new ParameterList();
        String[][] param = Grib2JpegDecoder.getAllParameters();
        for (int i = param.length - 1; i >= 0; --i) {
            if (param[i][3] == null) continue;
            defpl.put((Object)param[i][0], (Object)param[i][3]);
        }
        this.pl = new ParameterList(defpl);
        try {
            this.pl.parseArgs(argv);
        }
        catch (StringFormatException e) {
            System.err.format("An error occurred while parsing the arguments: %s", e.getMessage());
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean hasSignedProblem() {
        return this.hasSignedProblem;
    }

    public void decode(byte[] buf) throws IOException {
        boolean verbose = false;
        try {
            InvCompTransf color;
            InverseWT invWT;
            Dequantizer deq;
            ROIDeScaler roids;
            EntropyDecoder entdec;
            int i;
            HeaderDecoder hd;
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ISRandomAccessIO in = new ISRandomAccessIO((InputStream)bais, buf.length, 1, buf.length);
            FileFormatReader ff = new FileFormatReader((RandomAccessIO)in);
            ff.readFileFormat();
            if (ff.JP2FFUsed) {
                in.seek(ff.getFirstCodeStreamPos());
                logger.warn("ff.JP2FFUsed is used");
            }
            HeaderInfo hi = new HeaderInfo();
            try {
                hd = new HeaderDecoder((RandomAccessIO)in, this.pl, hi);
            }
            catch (EOFException e) {
                this.error("Codestream too short or bad header, unable to decode.", 2, e);
                throw e;
            }
            int nCompCod = hd.getNumComps();
            DecoderSpecs decSpec = hd.getDecoderSpecs();
            int[] depth = new int[nCompCod];
            for (i = 0; i < nCompCod; ++i) {
                depth[i] = hd.getOriginalBitDepth(i);
            }
            BitstreamReaderAgent breader = BitstreamReaderAgent.createInstance((RandomAccessIO)in, (HeaderDecoder)hd, (ParameterList)this.pl, (DecoderSpecs)decSpec, (boolean)false, (HeaderInfo)hi);
            try {
                entdec = hd.createEntropyDecoder((CodedCBlkDataSrcDec)breader, this.pl);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate entropy decoder", 2, e);
                return;
            }
            try {
                roids = hd.createROIDeScaler((CBlkQuantDataSrcDec)entdec, this.pl, decSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate roi de-scaler", 2, e);
                return;
            }
            try {
                deq = hd.createDequantizer((CBlkQuantDataSrcDec)roids, depth, decSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate dequantizer", 2, e);
                return;
            }
            try {
                invWT = InverseWT.createInstance((CBlkWTDataSrcDec)deq, (DecoderSpecs)decSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Cannot instantiate inverse wavelet transform", 2, e);
                return;
            }
            int res = breader.getImgRes();
            invWT.setImgResLevel(res);
            ImgDataConverter converter = new ImgDataConverter((BlkImgDataSrc)invWT, 0);
            InvCompTransf ictransf = new InvCompTransf((BlkImgDataSrc)converter, decSpec, depth, this.pl);
            String p = this.pl.getParameter("nocolorspace");
            boolean nocolorspace = "off".equals(p);
            if (ff.JP2FFUsed && nocolorspace) {
                try {
                    this.csMap = new ColorSpace((RandomAccessIO)in, hd, this.pl);
                    BlkImgDataSrc channels = hd.createChannelDefinitionMapper((BlkImgDataSrc)ictransf, this.csMap);
                    BlkImgDataSrc resampled = hd.createResampler(channels, this.csMap);
                    BlkImgDataSrc palettized = hd.createPalettizedColorSpaceMapper(resampled, this.csMap);
                    color = hd.createColorSpaceMapper(palettized, this.csMap);
                }
                catch (IllegalArgumentException e) {
                    this.error("Could not instantiate ICC profiler", 1, e);
                    return;
                }
                catch (ColorSpaceException e) {
                    this.error("error processing jp2 colorspace information", 1, e);
                    return;
                }
            } else {
                color = ictransf;
            }
            InvCompTransf decodedImage = color;
            if (color == null) {
                decodedImage = ictransf;
            }
            int nCompImg = decodedImage.getNumComps();
            ImgWriter[] imwriter = new ImgWriter[nCompImg];
            for (i = 0; i < imwriter.length; ++i) {
                boolean isSigned;
                try {
                    if (this.csMap != null) {
                        isSigned = this.csMap.isOutputSigned(i);
                        imwriter[i] = new ImgWriterArray((BlkImgDataSrc)decodedImage, i, this.csMap.isOutputSigned(i));
                    } else {
                        isSigned = hd.isOriginalSigned(i);
                        imwriter[i] = new ImgWriterArray((BlkImgDataSrc)decodedImage, i, hd.isOriginalSigned(i));
                    }
                }
                catch (IOException e) {
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    return;
                }
                try {
                    imwriter[i].writeAll();
                    ImgWriterArray iwa = (ImgWriterArray)imwriter[i];
                    this.data = iwa.getGdata();
                    if (!isSigned) {
                        int nb = depth[i];
                        int levShift = 1 << nb - 1;
                        if (nb != this.rate) {
                            this.hasSignedProblem = true;
                        }
                        int j = 0;
                        while (j < this.data.length) {
                            int n = j++;
                            this.data[n] = this.data[n] + levShift;
                        }
                    }
                    this.packBytes = iwa.getPackBytes();
                    continue;
                }
                catch (IOException e) {
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    return;
                }
            }
            if (verbose) {
                float bitrate = breader.getActualRate();
                int numBytes = breader.getActualNbytes();
                if (ff.JP2FFUsed) {
                    int imageSize = (int)(8.0f * (float)numBytes / bitrate);
                    bitrate = (float)(numBytes += ff.getFirstCodeStreamPos()) * 8.0f / (float)imageSize;
                }
                if (this.pl.getIntParameter("ncb_quit") == -1) {
                    logger.info("Actual bit rate = " + bitrate + " bpp (i.e. " + numBytes + " bytes)");
                } else {
                    logger.info("Number of packet body bytes read = " + numBytes);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.error(e.getMessage(), 2);
            if (this.debug) {
                e.printStackTrace();
            }
        }
        catch (RuntimeException e) {
            this.error("An uncaught runtime exception has occurred", 2, e);
            throw new IOException(e);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    private void error(String msg, int code) {
        this.exitCode = code;
        logger.debug(msg);
    }

    private void error(String msg, int code, Throwable e) {
        this.exitCode = code;
        logger.debug(String.format("%s=%s", msg, e.getMessage()));
        if (this.debug) {
            e.printStackTrace();
        }
    }

    public int getPackBytes() {
        return this.packBytes;
    }

    public int[] getGdata() {
        return this.data;
    }

    public static String[][] getAllParameters() {
        int i;
        ArrayList<String[]> vec = new ArrayList<String[]>();
        String[][] str = BitstreamReaderAgent.getParameterInfo();
        if (str != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.add(str[i]);
            }
        }
        if ((str = EntropyDecoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.add(str[i]);
            }
        }
        if ((str = ROIDeScaler.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.add(str[i]);
            }
        }
        if ((str = Dequantizer.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.add(str[i]);
            }
        }
        if ((str = InvCompTransf.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.add(str[i]);
            }
        }
        if ((str = HeaderDecoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.add(str[i]);
            }
        }
        if ((str = ICCProfiler.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.add(str[i]);
            }
        }
        if ((str = Decoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.add(str[i]);
            }
        }
        String[][] result = new String[vec.size()][];
        for (i = vec.size() - 1; i >= 0; --i) {
            result[i] = (String[])vec.get(i);
        }
        return result;
    }

    private static class ImgWriterArray
    extends ImgWriter {
        final boolean isSigned;
        private final int bitDepth;
        private DataBlkInt db = new DataBlkInt();
        private final int c;
        private int packBytes;

        ImgWriterArray(BlkImgDataSrc imgSrc, int c, boolean isSigned) throws IOException {
            this.c = c;
            this.isSigned = isSigned;
            this.src = imgSrc;
            this.w = this.src.getImgWidth();
            this.h = this.src.getImgHeight();
            this.bitDepth = this.src.getNomRangeBits(this.c);
            if (this.bitDepth <= 0 || this.bitDepth > 31) {
                throw new IOException("Array supports only bit-depth between 1 and 31");
            }
            this.packBytes = this.bitDepth <= 8 ? 1 : (this.bitDepth <= 16 ? 2 : 4);
        }

        public void close() {
        }

        public void write(int ulx, int uly, int w, int h) {
            this.db.ulx = ulx;
            this.db.uly = uly;
            this.db.w = w;
            this.db.h = h;
            if (this.db.data != null && this.db.data.length < w * h) {
                this.db.data = null;
            }
            do {
                this.db = (DataBlkInt)this.src.getInternCompData((DataBlk)this.db, this.c);
            } while (this.db.progressive);
        }

        public void writeAll() {
            Coord nT = this.src.getNumTiles(null);
            for (int y = 0; y < nT.y; ++y) {
                for (int x = 0; x < nT.x; ++x) {
                    this.src.setTile(x, y);
                    this.write(0, 0, this.src.getImgWidth(), this.src.getImgHeight());
                }
            }
        }

        public void write() {
            int tIdx = this.src.getTileIdx();
            int tw = this.src.getTileCompWidth(tIdx, this.c);
            int th = this.src.getTileCompHeight(tIdx, this.c);
            for (int i = 0; i < th; i += 64) {
                this.write(0, i, tw, th - i < 64 ? th - i : 64);
            }
        }

        int getPackBytes() {
            return this.packBytes;
        }

        int[] getGdata() {
            return this.db.data;
        }

        public void flush() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).add("isSigned", this.isSigned).add("bitDepth", this.bitDepth).add("component", this.c).add("w", this.w).add("h", this.h).toString();
        }
    }
}

