/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateSharerBest;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;

public class GribBestDatasetBuilder {
    static void makeDatasetBest(GribCollectionMutable result, List<GribCollectionMutable.GroupGC> groups2D, boolean isComplete) {
        GribCollectionMutable.Dataset dsBest = result.makeDataset(isComplete ? GribCollectionImmutable.Type.BestComplete : GribCollectionImmutable.Type.Best);
        for (GribCollectionMutable.GroupGC group2D : groups2D) {
            GribCollectionMutable.GroupGC groupB = dsBest.addGroupCopy(group2D);
            groupB.isTwoD = false;
            HashMap<Coordinate, CoordinateTimeAbstract> map2DtoBest = new HashMap<Coordinate, CoordinateTimeAbstract>();
            CoordinateSharerBest sharer = new CoordinateSharerBest();
            for (Coordinate coord : group2D.coords) {
                if (coord instanceof CoordinateRuntime) continue;
                if (coord instanceof CoordinateTime2D) {
                    CoordinateTimeAbstract best = ((CoordinateTime2D)coord).makeBestTimeCoordinate(result.masterRuntime);
                    if (!isComplete) {
                        best = best.makeBestFromComplete();
                    }
                    sharer.addCoordinate(best);
                    map2DtoBest.put(coord, best);
                    continue;
                }
                sharer.addCoordinate(coord);
            }
            groupB.coords = sharer.finish();
            for (GribCollectionMutable.VariableIndex vi2d : group2D.variList) {
                GribCollectionMutable.VariableIndex viBest = result.makeVariableIndex(groupB, vi2d);
                groupB.addVariable(viBest);
                ArrayList<Coordinate> newCoords = new ArrayList<Coordinate>();
                for (Integer groupIndex : vi2d.coordIndex) {
                    Coordinate coord2D = group2D.coords.get(groupIndex);
                    if (coord2D instanceof CoordinateRuntime) continue;
                    if (coord2D instanceof CoordinateTime2D) {
                        newCoords.add((Coordinate)map2DtoBest.get(coord2D));
                        continue;
                    }
                    newCoords.add(coord2D);
                }
                viBest.coordIndex = sharer.reindex(newCoords);
            }
        }
    }
}

