/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib1SectionIndicator {
    static final byte[] MAGIC = new byte[]{71, 82, 73, 66};
    private final long messageLength;
    private final long startPos;
    private final int messageLengthNotFixed;
    boolean isMessageLengthFixed = false;

    public Grib1SectionIndicator(RandomAccessFile raf) throws IOException {
        this.startPos = raf.getFilePointer();
        byte[] b = new byte[4];
        raf.readFully(b);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == MAGIC[i]) continue;
            throw new IllegalArgumentException("Not a GRIB record");
        }
        this.messageLengthNotFixed = GribNumbers.uint3(raf);
        int edition = raf.read();
        if (edition != 1) {
            throw new IllegalArgumentException("Not a GRIB-1 record");
        }
        this.messageLength = Grib1RecordScanner.getFixedTotalLengthEcmwfLargeGrib(raf, this.messageLengthNotFixed);
        if (this.messageLength != (long)this.messageLengthNotFixed) {
            this.isMessageLengthFixed = true;
        }
    }

    public Grib1SectionIndicator(long startPos, long messageLength) {
        this.startPos = startPos;
        this.messageLength = messageLength;
        this.messageLengthNotFixed = (int)messageLength;
        this.isMessageLengthFixed = false;
    }

    public long getMessageLength() {
        return this.messageLength;
    }

    public long getStartPos() {
        return this.startPos;
    }

    public long getEndPos() {
        return this.startPos + this.messageLength;
    }
}

