/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.IOException;
import ucar.ma2.DataType;
import ucar.unidata.io.RandomAccessFile;

public final class GribNumbers {
    public static final int UNDEFINED = -9999;
    public static final double UNDEFINEDD = -9999.0;
    public static final int[] bitmask = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    public static final int MISSING = 255;

    public static int getMaskForBit(int gribBitNumber) {
        return bitmask[gribBitNumber - 1];
    }

    public static boolean testBitIsSet(int test, int gribBitNumber) {
        return (test & GribNumbers.getMaskForBit(gribBitNumber)) != 0;
    }

    public static boolean isUndefined(double d) {
        return Double.compare(d, -9999.0) == 0;
    }

    public static int int2(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        return GribNumbers.int2(a, b);
    }

    public static int uint(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        return DataType.unsignedByteToShort((byte)((byte)a));
    }

    public static int int2(int a, int b) {
        if (a == 255 && b == 255) {
            return -9999;
        }
        return (1 - ((a & 0x80) >> 6)) * ((a & 0x7F) << 8 | b);
    }

    public static int int3(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        int c = raf.read();
        return GribNumbers.int3(a, b, c);
    }

    public static int int3(int a, int b, int c) {
        return (1 - ((a & 0x80) >> 6)) * ((a & 0x7F) << 16 | b << 8 | c);
    }

    public static int int4(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        int c = raf.read();
        int d = raf.read();
        return GribNumbers.int4(a, b, c, d);
    }

    public static int int4(int a, int b, int c, int d) {
        if (a == 255 && b == 255 && c == 255 && d == 255) {
            return -9999;
        }
        return (1 - ((a & 0x80) >> 6)) * ((a & 0x7F) << 24 | b << 16 | c << 8 | d);
    }

    public static int uint2(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        return GribNumbers.uint2(a, b);
    }

    public static int uint2(int a, int b) {
        return a << 8 | b;
    }

    public static int uint3(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        int c = raf.read();
        return GribNumbers.uint3(a, b, c);
    }

    public static int uint3(int a, int b, int c) {
        return a << 16 | b << 8 | c;
    }

    public static float float4(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        int c = raf.read();
        int d = raf.read();
        return GribNumbers.float4(a, b, c, d);
    }

    public static float float4(int a, int b, int c, int d) {
        int mant = b << 16 | c << 8 | d;
        if (mant == 0) {
            return 0.0f;
        }
        int sgn = -(((a & 0x80) >> 6) - 1);
        int exp = (a & 0x7F) - 64;
        return (float)((double)sgn * Math.pow(16.0, exp - 6) * (double)mant);
    }

    public static long int8(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        int c = raf.read();
        int d = raf.read();
        int e = raf.read();
        int f = raf.read();
        int g = raf.read();
        int h = raf.read();
        return (long)(1 - ((a & 0x80) >> 6)) * ((long)(a & 0x7F) << 56 | (long)b << 48 | (long)c << 40 | (long)d << 32 | (long)(e << 24) | (long)(f << 16) | (long)(g << 8) | (long)h);
    }

    public static int convertSignedByte(byte v) {
        int sign = (v & 0x80) != 0 ? -1 : 1;
        int value = v & 0x7F;
        return sign * value;
    }

    public static int convertSignedByte2(byte v) {
        return v >= 0 ? v : -(128 + v);
    }

    public static int countBits(byte[] bitmap) {
        int bits = 0;
        for (byte b : bitmap) {
            short s = DataType.unsignedByteToShort((byte)b);
            bits += Long.bitCount(s);
        }
        return bits;
    }

    public static void main(String[] args) {
        System.out.printf("byte == convertSignedByte == convertSignedByte2 == hex%n", new Object[0]);
        for (int i = 125; i < 256; ++i) {
            byte b = (byte)i;
            System.out.printf("%d == %d == %d == %s%n", b, GribNumbers.convertSignedByte(b), GribNumbers.convertSignedByte2(b), Long.toHexString(i));
            assert (GribNumbers.convertSignedByte(b) == GribNumbers.convertSignedByte2(b)) : GribNumbers.convertSignedByte(b) + "!=" + GribNumbers.convertSignedByte2(b);
        }
        short val = DataType.unsignedByteToShort((byte)56);
        int val2 = DataType.unsignedShortToInt((short)-200);
        System.out.printf("%d != %d%n", val, val2);
    }
}

