/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import ucar.nc2.grib.GribData;

public class QuasiRegular {
    public static float[] convertQuasiGrid(float[] quasi, int[] linePts, int nx, int ny, GribData.InterpolationMethod interpolationMethod) {
        if (interpolationMethod == GribData.InterpolationMethod.none) {
            return quasi;
        }
        int max = QuasiRegular.getMax(linePts);
        if (nx < 0) {
            assert (ny == linePts.length);
            nx = max;
        } else {
            assert (ny < 0);
            assert (nx == linePts.length);
            ny = max;
        }
        double x1_der = 1.0E30;
        double xn_der = 1.0E30;
        int inputIdx = 0;
        int outputIdx = 0;
        float[] data = new float[nx * ny];
        if (interpolationMethod == GribData.InterpolationMethod.cubic) {
            for (int j = 0; j < ny; ++j) {
                int i;
                int npoints = linePts[j];
                if (npoints == nx) {
                    for (i = 0; i < nx; ++i) {
                        data[outputIdx++] = quasi[inputIdx++];
                    }
                    continue;
                }
                double[] second_d = new double[npoints];
                QuasiRegular.secondDerivative(quasi, inputIdx, npoints, x1_der, xn_der, second_d);
                for (i = 0; i < nx; ++i) {
                    double mapped_i = (float)i / (float)nx * (float)npoints;
                    QuasiRegular.cubicSpline(quasi, inputIdx, second_d, mapped_i, data, outputIdx++);
                }
                inputIdx += npoints;
            }
        } else if (interpolationMethod == GribData.InterpolationMethod.linear) {
            for (int j = 0; j < ny; ++j) {
                int i;
                int npoints = linePts[j];
                if (npoints == nx) {
                    for (i = 0; i < nx; ++i) {
                        data[outputIdx++] = quasi[inputIdx++];
                    }
                    continue;
                }
                for (i = 0; i < nx; ++i) {
                    double mapped_i = (float)i / (float)nx * (float)npoints;
                    QuasiRegular.linear(quasi, inputIdx, mapped_i, data, outputIdx++, npoints);
                }
                inputIdx += npoints;
            }
        } else {
            throw new RuntimeException("unsupported interpolation method");
        }
        return data;
    }

    public static int getMax(int[] vals) {
        int max = 0;
        for (int v : vals) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    public static void secondDerivative(float[] inpt, int idx, int n, double x1d, double xnd, double[] y2d) {
        double qn;
        double un;
        int i;
        double[] scratch = new double[n - 1];
        if (x1d > 9.9E29) {
            scratch[0] = 0.0;
            y2d[0] = 0.0;
        } else {
            y2d[0] = 0.5;
            scratch[0] = 3.0 * ((double)(inpt[idx + 1] - inpt[idx]) / (1.0 - x1d));
        }
        for (i = 1; i < n - 1; ++i) {
            double sig = 0.5;
            double p = sig * y2d[i - 1] + 2.0;
            y2d[i] = (sig - 1.0) / p;
            scratch[i] = inpt[idx + i + 1] - inpt[idx + i] - (inpt[idx + i] - inpt[idx + i - 1]);
            scratch[i] = (6.0 * scratch[i] / 2.0 - sig * scratch[i - 1]) / p;
        }
        if (xnd > 9.9E29) {
            un = 0.0;
            qn = 0.0;
        } else {
            qn = 0.5;
            un = 3.0 * (xnd - (double)(inpt[idx + n - 1] - inpt[idx + n - 2]));
        }
        y2d[n - 1] = (un - qn * scratch[n - 2]) / (qn * y2d[n - 2] + 1.0);
        for (i = n - 2; i >= 0; --i) {
            y2d[i] = y2d[i] * y2d[i + 1] + scratch[i];
        }
    }

    public static void cubicSpline(float[] inpt, int iIdx, double[] y2d, double x, float[] outpt, int oIdx) {
        if (Math.floor(x) == x) {
            outpt[oIdx] = inpt[iIdx + (int)x];
            return;
        }
        int hi = (int)Math.ceil(x);
        int low = (int)Math.floor(x);
        double a = (double)hi - x;
        double b = x - (double)low;
        hi = hi > y2d.length - 1 ? 0 : hi;
        outpt[oIdx] = (float)(a * (double)inpt[iIdx + low] + b * (double)inpt[iIdx + hi] + ((a * a * a - a) * y2d[low] + (b * b * b - b) * y2d[hi]) / 6.0);
    }

    public static void linear(float[] inpt, int iIdx, double x, float[] outpt, int oIdx, int npoints) {
        if (Math.floor(x) == x) {
            outpt[oIdx] = inpt[iIdx + (int)x];
            return;
        }
        int hi = (int)Math.ceil(x);
        int low = (int)Math.floor(x);
        double a = (double)hi - x;
        double b = x - (double)low;
        int hiIdx = hi > npoints - 1 ? iIdx : iIdx + hi;
        int lowIdx = iIdx + low;
        if (lowIdx >= inpt.length || hiIdx >= inpt.length) {
            System.out.printf("HEY%n", new Object[0]);
        }
        outpt[oIdx] = (float)(a * (double)inpt[lowIdx] + b * (double)inpt[hiIdx]);
    }
}

