/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MFile;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.iosp.IOServiceProvider;

public class Grib1Collection
extends GribCollectionImmutable {
    Grib1Collection(GribCollectionMutable gc) {
        super(gc);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getLocation(), null);
            return new NetcdfDataset((NetcdfFile)ncfile);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollectionImmutable gc = GribCdmIndex.openGribCollectionFromDataFile(true, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            Grib1Iosp iosp = new Grib1Iosp(gc);
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getLocation(), null);
            return new NetcdfDataset((NetcdfFile)ncfile);
        }
        return null;
    }

    @Override
    public GridDataset getGridDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getLocation() + "#" + group.getId(), null);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
            return new GridDataset(ncd);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollectionImmutable gc = GribCdmIndex.openGribCollectionFromDataFile(true, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            Grib1Iosp iosp = new Grib1Iosp(gc);
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getLocation(), null);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
            return new GridDataset(ncd);
        }
        return null;
    }

    @Override
    protected void addGlobalAttributes(List<Attribute> result) {
        String val = this.cust.getGeneratingProcessName(this.getGenProcessId());
        if (val != null) {
            result.add(new Attribute("Generating_process_or_model", val));
        }
        result.add(new Attribute("file_format", DataFormatType.GRIB1.getDescription()));
    }
}

