/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.IOException;
import java.io.InputStream;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.Grib2Table;
import ucar.nc2.grib.grib2.table.LocalTables;
import ucar.nc2.util.TableParser;

public class GempakLocalTables
extends LocalTables {
    private static boolean debug = false;
    private static GempakLocalTables single;

    public static GempakLocalTables getCust(Grib2Table table) {
        if (single == null) {
            single = new GempakLocalTables(table);
        }
        return single;
    }

    GempakLocalTables(Grib2Table grib2Table) {
        super(grib2Table);
        Formatter f = new Formatter();
        this.local = this.initLocalTable(grib2Table.getPath(), f);
        System.out.printf("%s%n", f);
    }

    private Map<Integer, Grib2Parameter> initLocalTable(String resourcePath, Formatter f) {
        HashMap<Integer, Grib2Parameter> result = new HashMap<Integer, Grib2Parameter>(100);
        try (InputStream is = GribResourceReader.getInputStream(resourcePath);){
            if (is == null) {
                throw new IllegalStateException("Cant find " + resourcePath);
            }
            if (f != null) {
                f.format("%s, %-20s, %-20s, %-20s%n", "id", "name", "units", "gname");
            }
            TableParser parser = new TableParser("3i,7i,11i,15i,49,69,74,");
            parser.setComment("!");
            List recs = parser.readAllRecords(is, 50000);
            for (TableParser.Record record : recs) {
                int disc = (Integer)record.get(0);
                int cat = (Integer)record.get(1);
                int id = (Integer)record.get(2);
                int template = (Integer)record.get(3);
                String name = ((String)record.get(4)).trim();
                String units = ((String)record.get(5)).trim();
                String gname = ((String)record.get(6)).trim();
                String ids = disc + "-" + cat + "-" + id;
                if (f != null) {
                    f.format("%s == %-20s, %-20s, %-20s%n", ids, name, units, gname);
                }
                Grib2Parameter gp = new Grib2Parameter(disc, cat, id, gname, units, null, name);
                result.put(Grib2Customizer.makeParamId(disc, cat, id), gp);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return result;
    }
}

