/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionMutable;
import ucar.nc2.iosp.IOServiceProvider;

public class Grib1Partition
extends PartitionCollectionImmutable {
    Grib1Partition(PartitionCollectionMutable pc) {
        super(pc);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
        NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getLocation(), null);
        return new NetcdfDataset((NetcdfFile)ncfile);
    }

    @Override
    public GridDataset getGridDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
        NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getLocation(), null);
        NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
        return new GridDataset(ncd);
    }

    @Override
    protected void addGlobalAttributes(List<Attribute> result) {
        String val = this.cust.getGeneratingProcessName(this.getGenProcessId());
        if (val != null) {
            result.add(new Attribute("Generating_process_or_model", val));
        }
        result.add(new Attribute("file_format", DataFormatType.GRIB1.getDescription()));
    }
}

