/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.coord.Coordinate;

public class CoordinateUniquify {
    private static Logger logger = LoggerFactory.getLogger(CoordinateUniquify.class);
    HashMap<Coordinate, Coordinate> runtimeBuilders = new HashMap();
    HashMap<Coordinate, Coordinate> timeBuilders = new HashMap();
    HashMap<Coordinate, Coordinate> timeIntvBuilders = new HashMap();
    HashMap<Coordinate, Coordinate> vertBuilders = new HashMap();
    HashMap<Coordinate, Coordinate> ensBuilders = new HashMap();
    HashMap<Coordinate, Coordinate> time2DBuilders = new HashMap();
    HashMap<Coordinate, Coordinate> swap = new HashMap();
    List<Coordinate> unionCoords;
    Map<Coordinate, Integer> indexMap;

    public void addCoordinates(List<Coordinate> coords) {
        for (Coordinate coord : coords) {
            this.addCoordinate(coord);
        }
    }

    public void addCoordinate(Coordinate coord) {
        switch (coord.getType()) {
            case runtime: {
                Coordinate already = this.runtimeBuilders.get(coord);
                if (already == null) {
                    this.runtimeBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
                break;
            }
            case time: {
                Coordinate already = this.timeBuilders.get(coord);
                if (already == null) {
                    this.timeBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
                break;
            }
            case timeIntv: {
                Coordinate already = this.timeIntvBuilders.get(coord);
                if (already == null) {
                    this.timeIntvBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
                break;
            }
            case time2D: {
                Coordinate already = this.time2DBuilders.get(coord);
                if (already == null) {
                    this.time2DBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
                break;
            }
            case vert: {
                Coordinate already = this.vertBuilders.get(coord);
                if (already == null) {
                    this.vertBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
                break;
            }
            case ens: {
                Coordinate already = this.ensBuilders.get(coord);
                if (already == null) {
                    this.ensBuilders.put(coord, coord);
                    break;
                }
                this.swap.put(coord, already);
            }
        }
    }

    public List<Coordinate> finish() {
        this.unionCoords = new ArrayList<Coordinate>(20);
        for (Coordinate coord : this.runtimeBuilders.keySet()) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.time2DBuilders.keySet()) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.timeBuilders.keySet()) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.timeIntvBuilders.keySet()) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.vertBuilders.keySet()) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.ensBuilders.keySet()) {
            this.unionCoords.add(coord);
        }
        this.indexMap = new HashMap<Coordinate, Integer>();
        for (int i = 0; i < this.unionCoords.size(); ++i) {
            this.indexMap.put(this.unionCoords.get(i), i);
        }
        return this.unionCoords;
    }

    public List<Integer> reindex(List<Coordinate> coords) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Coordinate coord : coords) {
            Coordinate sub = this.swap.get(coord);
            Coordinate use = sub == null ? coord : sub;
            Integer idx = this.indexMap.get(use);
            if (idx == null) {
                throw new IllegalStateException();
            }
            result.add(idx);
        }
        return result;
    }
}

